import { Tab } from './tab';
import { ExecOptions } from '../models/execOptions';
export interface Prompt extends HTMLInputElement {
    execOptions?: ExecOptions;
}
export declare const getBlockOfPrompt: (prompt: HTMLInputElement) => HTMLElement;
export declare const getPrompt: (block: HTMLElement) => Prompt;
export declare const getBottomPrompt: () => HTMLInputElement;
export declare const getInitialPrompt: (tab: Tab) => HTMLInputElement;
export declare const getCurrentPrompt: (tab?: Tab) => Prompt;
export declare const getPromptFromTarget: (target: EventTarget) => HTMLInputElement;
export declare const getPromptLeft: (block: Element) => Element;
export declare const getCurrentPromptLeft: (tab: Tab) => Element;
export declare function installContext(block: HTMLElement): void;
export declare function isUsingCustomPrompt(prompt: HTMLInputElement): boolean;
export declare const partial: (cmd: string, execOptions?: ExecOptions) => void;
export declare function setUsingCustomPrompt(block: HTMLElement): void;
export declare function unsetUsingCustomPrompt(block: HTMLElement): void;
