"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const tab_1 = require("./tab");
const types_1 = require("../util/types");
function stripe() {
    return document.querySelector('#kui--status-stripe');
}
function region(pos) {
    return stripe().querySelector(`.kui--status-stripe-${pos}`);
}
function hasId(fragment) {
    return typeof fragment.id === 'string';
}
function isTextWithIcon(fragment) {
    const twi = fragment;
    return typeof twi.icon === 'string' && types_1.isHTML(twi.text);
}
class ElementController {
    constructor(element, fragment) {
        this.element = element;
        this.fragment = fragment;
    }
    showAs(level) {
        this.element.setAttribute('data-view', level);
        return this;
    }
    unlisten(myListener) {
        return __awaiter(this, void 0, void 0, function* () {
            const { default: eventBus } = yield Promise.resolve().then(() => require('../core/events'));
            eventBus.off('/tab/new', myListener);
            eventBus.off('/tab/switch', myListener);
            eventBus.off('/command/complete/fromuser', myListener);
        });
    }
    listen(listener) {
        return __awaiter(this, void 0, void 0, function* () {
            const myListener = (tab) => {
                if (tab === tab_1.getCurrentTab()) {
                    Promise.resolve(listener(tab, this, this.fragment)).catch(err => {
                        console.error('error refreshing status stripe fragment', err);
                        this.showAs('hidden');
                    });
                }
            };
            const { default: eventBus } = yield Promise.resolve().then(() => require('../core/events'));
            eventBus.on('/tab/new', myListener);
            eventBus.on('/tab/switch', myListener);
            eventBus.on('/command/complete/fromuser', myListener);
            return myListener;
        });
    }
}
class StatusStripeAPI {
    render(fragment) {
        if (isTextWithIcon(fragment)) {
            const frag = document.createDocumentFragment();
            const icon = document.createElement('a');
            icon.href = '#';
            icon.classList.add(fragment.iconIsNarrow ? 'tiny-right-pad' : 'small-right-pad', 'kui--status-stripe-icon');
            icon.innerHTML = fragment.icon;
            if (fragment.onclick) {
                if (fragment.onclick.text) {
                    const clickable = document.createElement('a');
                    clickable.href = '#';
                    clickable.classList.add('clickable', 'kui--status-stripe-text');
                    clickable.appendChild(fragment.text);
                    fragment.text = clickable;
                    fragment.text.onclick = () => tab_1.getCurrentTab().REPL.pexec(fragment.onclick.text);
                }
                if (fragment.onclick.icon) {
                    icon.classList.add('clickable');
                    icon.onclick = () => tab_1.getCurrentTab().REPL.pexec(fragment.onclick.icon);
                }
            }
            frag.appendChild(icon);
            frag.appendChild(fragment.text);
            return frag;
        }
        else {
            throw new Error('unsupported fragment type');
        }
    }
    wrap(fragment) {
        const wrapper = document.createElement('div');
        wrapper.classList.add('kui--status-stripe-element');
        wrapper.appendChild(this.render(fragment));
        if (hasId(fragment)) {
            wrapper.classList.add(fragment.id);
        }
        return wrapper;
    }
    addTo(pos, fragment) {
        const element = this.wrap(fragment);
        region(pos).appendChild(element);
        return new ElementController(element, fragment).showAs('hidden');
    }
    remove(pos, fragment) {
        region(pos).removeChild(fragment);
    }
}
exports.default = new StatusStripeAPI();
//# sourceMappingURL=status-stripe.js.map