"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const usage_error_1 = require("../../core/usage-error");
const repl_1 = require("../../core/repl");
const utility_1 = require("../../core/utility");
const debug = debug_1.default('core/webapp/util/ascii-to-usage');
const sectionHeader = /^([^#%][A-Za-z ]+):\s*$/;
const splitter = /[\n\r]([^#%][A-Za-z ]+:\s*[\n\r])([-]+[\n\r])?/;
const matcher = /[\n\r]([^#%][A-Za-z ]+:\s*[\n\r])\s+\w+/;
const doubleNewline = /(\n\n)|(\r\r)|(\r\n\r\n)/;
class DefaultOptions {
}
const asciiToOptionsTable = (rows) => {
    const table = rows
        .map(line => {
        const [command, docs] = line.split(/\s\s+/);
        const aliases = command.split(/,\s*/);
        if (docs) {
            return {
                command: aliases[0],
                aliases: aliases.length > 1 && aliases.slice(1),
                docs
            };
        }
    })
        .filter(x => x);
    return table.length > 0 && table;
};
exports.formatUsage = (command, str, options = new DefaultOptions()) => {
    if (!matcher.test(str)) {
        return;
    }
    debug('raw', str);
    const rows = utility_1.flatten(`\n${str}`
        .split(splitter)
        .filter(x => x)
        .map(row => row.split(doubleNewline))).filter(x => x);
    debug('rows!', rows);
    if (rows.length > 2) {
        const sections = rows.slice(1).reduce((groups, row, idx, A) => {
            const maybeHeader = row.match(sectionHeader);
            debug('maybeHeader', row, maybeHeader, groups.length);
            if (maybeHeader) {
                groups.push({ title: maybeHeader[1].toLowerCase(), rows: [] });
            }
            else if (groups.length > 0 && !doubleNewline.test(row)) {
                if (idx > 0 && doubleNewline.test(A[idx - 1])) {
                    groups.push({ title: '', rows: [] });
                }
                const currentGroup = groups[groups.length - 1];
                debug('row', row, currentGroup.title, doubleNewline.test(A[idx - 1]));
                currentGroup.rows = row
                    .split(/\n/)
                    .filter(x => x)
                    .map(line => line.trim());
            }
            return groups;
        }, []);
        debug('sections', sections);
        if (sections.length > 0) {
            const nameSectionIdx = sections.findIndex(({ title }) => /Name/i.test(title));
            const usageSectionIdx = sections.findIndex(({ title }) => /Usage/i.test(title));
            const rest = sections
                .filter((_, idx) => idx !== nameSectionIdx && idx !== usageSectionIdx)
                .map(section => Object.assign(section, {
                nRowsInViewport: section.title.match(/Commands/i) ? 12 : 4,
                rows: asciiToOptionsTable(section.rows) || section.rows.join('\n')
            }));
            const header = nameSectionIdx >= 0 ? sections[nameSectionIdx].rows[0] : rows[0];
            const example = usageSectionIdx >= 0 && sections[usageSectionIdx].rows[0];
            debug('header', header, nameSectionIdx);
            debug('example', example, usageSectionIdx);
            const commandWithoutOptions = command.replace(/\s--?\w+/g, '');
            const breadcrumbs = repl_1.split(commandWithoutOptions);
            debug('command', command);
            debug('breadcrumbs', breadcrumbs);
            debug('rest', rest);
            const model = Object.assign({
                command: breadcrumbs.pop(),
                parents: breadcrumbs,
                commandPrefix: command.replace(new RegExp('\\s--?\\w+'), ''),
                commandSuffix: '--help',
                header,
                example,
                sections: rest,
                preserveCase: true
            }, options);
            return new usage_error_1.default({ messageDom: options.stderr, usage: model });
        }
    }
};
//# sourceMappingURL=ascii-to-usage.js.map