"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const capabilities_1 = require("../../core/capabilities");
const debug = debug_1.default('webapp/util/inject');
debug('loading');
function isAStylesheetDirect(object) {
    return typeof object !== 'string' && 'css' in object && 'key' in object;
}
function isAStylesheetFile(object) {
    return typeof object !== 'string' && 'path' in object && 'key' in object;
}
exports.injectCSS = (file) => {
    if (capabilities_1.isHeadless() || typeof document === 'undefined' || !document.getElementById) {
        return;
    }
    const contentType = 'text/css';
    const rel = 'stylesheet';
    const id = isAStylesheetDirect(file) || isAStylesheetFile(file) ? `injected-css-${file.key}` : `injected-css-${file}`;
    if (!document.getElementById(id)) {
        let link;
        if (isAStylesheetDirect(file)) {
            link = document.createElement('style');
            link.appendChild(document.createTextNode(file.css));
        }
        else {
            link = document.createElement('link');
            link.rel = rel;
            const muri = typeof mediaUri !== 'undefined' ? mediaUri + '/' : '';
            if (isAStylesheetFile(file)) {
                link.href = `${muri}${file.path}`;
            }
            else {
                link.href = `${muri}${file}`;
            }
        }
        link.id = id;
        link.type = contentType;
        document.getElementsByTagName('head')[0].appendChild(link);
    }
};
exports.uninjectCSS = ({ key }) => {
    if (capabilities_1.isHeadless() || typeof document === 'undefined' || !document.getElementById) {
    }
    else {
        const id = `injected-css-${key}`;
        const link = document.getElementById(id);
        if (link && link.parentNode) {
            link.parentNode.removeChild(link);
        }
    }
};
exports.injectScript = (url) => {
    if (capabilities_1.isHeadless() || typeof document === 'undefined' || !document.getElementById) {
        return;
    }
    return new Promise(resolve => {
        const type = 'script';
        const id = `injected-${type}-${typeof url === 'string' ? url : url.key}`;
        if (!document.getElementById(id)) {
            const link = document.createElement('script');
            link.id = id;
            if (typeof url !== 'string') {
                link.appendChild(document.createTextNode(url.src));
            }
            else {
                link.async = true;
                link.src = url;
                link.addEventListener('load', () => {
                    resolve();
                });
            }
            document.getElementsByTagName('head')[0].appendChild(link);
        }
        else {
            resolve();
        }
    });
};
exports.loadHTML = (file) => new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
    if (file.html) {
        resolve(file.html);
    }
    else {
        const { readFile } = yield Promise.resolve().then(() => require('fs'));
        return readFile(file, (err, data) => {
            if (err) {
                reject(err);
            }
            else {
                resolve(data.toString());
            }
        });
    }
}));
//# sourceMappingURL=inject.js.map