import { Tab } from '../tab';
import { Sidecar } from './sidecar-core';
export declare function getBadgesDomContainer(sidecar: Sidecar): {
    badgesDomContainer: Element;
    badgesDom: HTMLElement;
};
export interface BadgeSpec {
    title: string;
    fontawesome?: string;
    image?: HTMLImageElement | SVGElement;
    css?: string;
    onclick?: (evt: MouseEvent) => boolean;
}
export declare type Badge = string | BadgeSpec | Element;
export interface BadgeOptions {
    css?: string;
    onclick?: () => void;
    badgesDom: Element;
}
export declare class DefaultBadgeOptions implements BadgeOptions {
    readonly badgesDom: HTMLElement;
    constructor(tab: Tab);
}
export declare const addBadge: (tab: Tab, badgeText: Badge, { css, onclick, badgesDom }?: BadgeOptions) => HTMLElement;
export declare const clearBadges: (tab: Tab) => void;
export declare function hasBadge(tab: Tab, cls: string): boolean;
