"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const sidecar_core_1 = require("./sidecar-core");
const tab_1 = require("../tab");
const presentation_1 = require("./presentation");
const scroll_1 = require("../scroll");
const events_1 = require("../../core/events");
exports.enableTabIndex = (sidecar, tabbable = true) => {
    const notabElements = document.querySelectorAll('.kui--notab-when-sidecar-hidden');
    notabElements.forEach(element => {
        if (tabbable) {
            element.removeAttribute('tabindex');
        }
        else {
            element.setAttribute('tabindex', '-1');
        }
    });
};
exports.isVisible = (tab) => {
    const sidecar = sidecar_core_1.getSidecar(tab);
    return !!(sidecar.classList.contains('visible') && sidecar);
};
exports.setVisibleClass = (sidecar) => {
    sidecar.classList.remove('minimized');
    sidecar.classList.add('visible');
};
const setVisible = (sidecar) => {
    const tab = tab_1.getTabFromTarget(sidecar);
    exports.setVisibleClass(sidecar);
    exports.enableTabIndex(sidecar);
    tab.classList.remove('sidecar-is-minimized');
    sidecar.classList.remove('minimized');
    document.body.classList.add('sidecar-visible');
    const replView = tab.querySelector('.repl');
    replView.classList.add('sidecar-visible');
    scroll_1.scrollIntoView();
    setTimeout(() => events_1.default.emit('/sidecar/toggle', { sidecar, tab }), 0);
};
exports.currentSelection = (tab) => {
    const sidecar = sidecar_core_1.getSidecar(tab);
    return sidecar && sidecar.entity;
};
exports.show = (tab, block, nextBlock) => __awaiter(void 0, void 0, void 0, function* () {
    const sidecar = sidecar_core_1.getSidecar(tab);
    if (exports.currentSelection(tab) || sidecar.className.indexOf('custom-content') >= 0) {
        setVisible(sidecar);
        exports.enableTabIndex(sidecar);
        return true;
    }
    else if (block && nextBlock) {
        const { oops } = yield Promise.resolve().then(() => require('../oops'));
        oops(undefined, block, nextBlock)(new Error('You have no entity to show'));
    }
});
exports.hide = (tab, clearSelectionToo = false) => {
    const sidecar = sidecar_core_1.getSidecar(tab);
    sidecar.classList.remove('visible');
    exports.enableTabIndex(sidecar, false);
    if (!clearSelectionToo) {
        sidecar.classList.add('minimized');
        tab.classList.add('sidecar-is-minimized');
    }
    else {
        document.body.classList.remove('sidecar-visible');
    }
    const replView = tab.querySelector('.repl');
    replView.classList.remove('sidecar-visible');
    if (clearSelectionToo && sidecar.entity) {
        delete sidecar.entity;
    }
    setTimeout(() => events_1.default.emit('/sidecar/toggle', { sidecar, tab }), 0);
    return true;
};
exports.clearSelection = (tab) => {
    return exports.hide(tab, true);
};
exports.toggle = (tab) => {
    if (!exports.isVisible(tab)) {
        return exports.show(tab);
    }
    else {
        const presentationString = document.body.getAttribute('data-presentation');
        const presentation = presentationString && presentation_1.default[presentationString];
        return presentation === presentation_1.default.SidecarThin ? exports.clearSelection(tab) : exports.hide(tab);
    }
};
exports.remove = (elt, cls) => elt.classList.remove(cls);
const add = (elt, cls) => elt.classList.add(cls);
const toggleClass = (elt, cls) => elt.classList.toggle(cls);
exports.setMaximization = (tab, op = add, cause = 'default') => {
    if (document.body.classList.contains('subwindow')) {
        op(document.body, 'sidecar-full-screen');
        op(document.body, 'sidecar-visible');
    }
    const before = tab.classList.contains('sidecar-full-screen');
    op(tab, 'sidecar-full-screen');
    const after = tab.classList.contains('sidecar-full-screen');
    if (before !== after) {
        setTimeout(() => events_1.default.emit('/sidecar/maximize'), 0);
    }
    if (after) {
        tab.setAttribute('maximization-cause', cause);
    }
    else {
        tab.removeAttribute('maximization-cause');
    }
};
exports.toggleMaximization = (tab, cause) => {
    exports.setMaximization(tab, toggleClass, cause);
};
exports.isFullscreen = (tab) => {
    return tab.classList.contains('sidecar-full-screen');
};
//# sourceMappingURL=sidecar-visibility.js.map