import Formattable from './formattable';
declare type ToolbarTextType = 'info' | 'warning' | 'error';
declare type ToolbarTextValue = string | Element;
export interface ToolbarText {
    type: ToolbarTextType;
    text: ToolbarTextValue;
}
export interface RefreshableToolbarText extends ToolbarText {
    attach: (owner: Element) => RefreshableToolbarText;
    refresh: () => void;
}
export declare class ToolbarTextImpl implements RefreshableToolbarText {
    type: ToolbarTextType;
    text: string | Element;
    private _container;
    constructor(type: ToolbarTextType, text: string | Element);
    attach(owner: Element): this;
    refresh(): void;
}
export declare function isToolbarText(subtext: Formattable | ToolbarText): subtext is ToolbarText;
export declare function isRefreshableToolbarText(ttext: ToolbarText): ttext is RefreshableToolbarText;
export {};
