/**
 * Is this a special @ directory?
 *
 */
export declare const isSpecialDirectory: (filepath: string) => boolean;
/**
 * Behaves like `findFile` with an extra call to `commandPrefix`
 *
 */
export declare const findFileWithViewer: (filepath: string, { safe, keepRelative }?: {
    safe?: boolean;
    keepRelative?: boolean;
}) => {
    resolved: string;
    viewer?: string;
};
/**
 * Resolve @ and ~ files
 *
 * @param safe throw and exception if the file is not found
 * @param keepRelative don't expand ~
 */
export declare const findFile: (filepath: string, { safe, keepRelative }?: {
    safe?: boolean;
    keepRelative?: boolean;
}) => string;
/**
 * Does the given special have an associated command prefix that is
 * used to view files in that special directory?
 *
 * @param special a registered prefix of an `ISpecialPath`
 * @return the registered command prefix used to view files in this special directory, if any
 */
export declare const viewer: (prefix: string) => string;
/**
 * Augment the module load path
 *
 * @param filepath e.g. /path/to/special
 * @param prefix e.g. @demos/tekton which is a valid extension of `filepath`
 * @param command a command prefix that is used to view files in this special directory
 */
export declare const addPath: (filepath: string, { prefix, command }?: {
    prefix?: string;
    command?: string;
}) => void;
