import { Abortable } from './job';
import { Entity } from '../../models/entity';
import { Row } from '../../webapp/models/table';
export interface Watcher {
    /**
     * the table renderer will call this function when the DOM
     * is ready to accept updates. when you have updates, please call
     * one or the other of the provided functions
     */
    init: (pusher: WatchPusher) => void;
}
export interface Watchable {
    watch: Watcher & Abortable;
}
/** callbacks to indicate state changes */
export interface WatchPusher {
    update: (response: Row) => void;
    offline: (rowKey: string) => void;
    done: () => void;
    allOffline: () => void;
    header: (response: Row) => void;
}
export declare function isWatchable(model: Entity & Partial<Watchable>): model is Entity & Watchable;
