/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { isTable } from '../../webapp/models/table';
import { isCustomSpec } from '../../webapp/views/custom-content';
import { isHTML } from '../../util/types';
export function isScalarContent(entity) {
    const content = entity.content;
    return (content !== undefined &&
        (typeof content === 'string' || isTable(content) || isHTML(content) || isCustomSpec(content)));
}
function isSupportedContentType(contentType) {
    return (contentType === 'yaml' || contentType === 'text/markdown' || contentType === 'text/html' || contentType === 'json');
}
export function isStringWithOptionalContentType(entity) {
    const str = entity;
    return (str && typeof str.content === 'string' && (str.contentType === undefined || typeof str.contentType === 'string'));
}
export function isFunctionContent(content) {
    const func = content;
    return !!func && !!func.content && typeof func.content === 'function';
}
export function isCommandStringContent(content) {
    const command = content;
    return (!!command &&
        typeof command.contentFrom === 'string' &&
        (command.contentType === undefined || isSupportedContentType(command.contentType)));
}
export function hasContent(resource) {
    return Object.prototype.hasOwnProperty.call(resource, 'content') || isCommandStringContent(resource);
}
//# sourceMappingURL=content-types.js.map