import { Tab } from './tab';
import { Block } from './models/block';
export declare const getInitialBlock: (tab: Tab) => HTMLElement;
export declare const getCurrentBlock: (tab?: Tab) => Block;
export declare const getCurrentProcessingBlock: (tab?: Tab) => HTMLElement;
/**
 * Remove any .repl-temporary structures from the given dom
 *
 */
export declare const removeAnyTemps: (block: Block, fullClean?: boolean) => Block;
export declare const installBlock: (parentNode: Node, currentBlock: HTMLElement, nextBlock: HTMLElement) => () => Promise<void>;
/**
 * Install a sub-block of output in the given block
 *
 */
export declare function subblock(): HTMLDivElement;
/**
 * Reset input count for the given block
 *
 */
export declare const resetCount: (block: HTMLElement) => void;
/**
 * Allow commands to take charge of the cursor/caret/block rendering
 *
 */
export declare const setCustomCaret: (block: HTMLElement) => void;
/**
 * Is the given `block` either the current active block in the given
 * `tab`, or the output of the previous command execution?
 *
 */
export declare function isMostRecentBlock(tab: Tab, block: Block): boolean;
