import { Tab } from './cli';
import { Table } from './models/table';
import { CustomSpec } from './views/sidecar-core';
import { ParsedOptions } from '../models/command';
import { MetadataBearing } from '../models/entity';
import { Mode, Button } from '../models/mmr/types';
/** clicking on a button can toggle other buttons */
export declare type SelectionController = {
    on: (evt: 'change', cb: (selected: boolean) => void) => void;
};
/**
 * Bottom stripe button specification
 *
 */
export declare type SidecarMode<T extends MetadataBearing = MetadataBearing> = Mode<T> | Button<T>;
export declare function isSidecarMode(entity: string | HTMLElement | Table | SidecarMode): entity is SidecarMode;
interface BottomStripOptions {
    show?: string;
    preserveBackButton?: boolean;
    /** only generate model, do not update view? */
    modelOnly?: boolean;
}
export declare const rawCSS: {
    buttons: string;
};
export declare const css: {
    buttons: (tab: Tab) => HTMLElement;
    backContainer: (tab: Tab) => HTMLElement;
    backButton: (tab: Tab) => HTMLElement;
    button: string;
    tab: string[];
    buttonAction: string;
    buttonActingAsButton: string;
    buttonActingAsRadioButton: string;
    modeContainer: (tab: Tab) => HTMLElement;
    bottomContainer: (tab: Tab) => HTMLElement;
    active: string;
    selected: string;
    hidden: string;
};
export declare const addModeButton: (tab: Tab, mode: SidecarMode<MetadataBearing<void>>, entity: Record<string, any>, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}) => HTMLLIElement | HTMLAnchorElement;
export declare const addModeButtons: (tab: Tab, modesUnsorted: SidecarMode<MetadataBearing<void>>[], entity: MetadataBearing<void> | CustomSpec<void>, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}, options?: BottomStripOptions) => SidecarMode<MetadataBearing<void>>[];
export {};
