import { Row, Table } from '../models/table';
/**
 * Split the given string at the given split indices
 *
 */
export interface Pair {
    key: string;
    value: string;
    valueDom: Element;
    css: string;
}
/**
 * Find the column splits
 *
 */
export declare const preprocessTable: (raw: string[]) => Promise<{
    rows?: Pair[][];
    trailingString?: string;
}[]>;
/** decorate certain columns specially */
export declare const outerCSSForKey: {
    [key: string]: string;
};
export declare const cssForKey: {
    [key: string]: string;
};
/** decorate certain values specially */
export declare const cssForValue: {
    [key: string]: string;
};
/**
 * Turn an IPair[][], i.e. a table of key-value pairs into a Table,
 * i.e. kui Table model. IPair is defined below, it is internal just
 * to this file.
 *
 * TODO factor out kube-specifics to plugin-k8s
 *
 */
export declare const formatTable: (entityType: string, lines: Pair[][]) => Table<Row>;
