import { Sidecar, getSidecar, CustomSpec, CustomContent } from './sidecar-core';
export { Sidecar, getSidecar, CustomSpec, CustomContent };
import { BadgeSpec, Badge, BadgeOptions } from './badge';
export { BadgeSpec, Badge, BadgeOptions };
import { Tab } from '../tab';
import { ShowOptions } from './show-options';
import { ToolbarText } from './toolbar-text';
import Presentation from './presentation';
import { MetadataBearing, MetadataBearingByReference, isMetadataBearingByReference, Entity } from '../../models/entity';
import { ParsedOptions } from '../../models/command';
import { ExecOptions } from '../../models/execOptions';
/** @deprecated */
export { MetadataBearingByReference };
export { isMetadataBearingByReference };
export declare const maybeHideEntity: (tab: Tab, entity: Entity<void, import("../..").Row, MetadataBearing<void>>) => boolean;
/**
 * Return the container of the current active sidecar view
 *
 */
export declare const getActiveView: (tab: Tab) => Element;
/**
 * If the entity has a version attribute, then render it
 *
 */
export declare const addVersionBadge: (tab: Tab, entity: MetadataBearing<void> | CustomSpec<void>, { clear, badgesDom }?: {
    clear?: boolean;
    badgesDom?: HTMLElement;
}) => void;
/**
 * Add view name to the sidecar header "icon text"
 *
 */
export declare const addSidecarHeaderIconText: (viewName: string, sidecar: HTMLElement) => void;
/**
 * @return the enclosing tab for the given sidecar
 *
 */
export declare const getEnclosingTab: (sidecar: Sidecar) => Tab;
/**
 * Given an entity name and an optional packageName, decorate the sidecar header
 *
 */
export declare const addNameToSidecarHeader: (sidecar: Sidecar, name: string | Element, packageName?: string, onclick?: () => void, viewName?: string, subtext?: string | HTMLElement | ToolbarText | Promise<string> | Promise<HTMLElement>, entity?: MetadataBearing<void> | MetadataBearingByReference<void> | CustomSpec<void>) => Promise<Element>;
export declare const showCustom: (tab: Tab, custom: CustomSpec<void>, options?: ExecOptions, argvNoOptions?: string[], parsedOptions?: ParsedOptions, resultDom?: Element) => Promise<Presentation>;
/**
 * Register a renderer for a given <kind>
 *
 */
export declare type ISidecarViewHandler = (tab: Tab, entity: Object, // eslint-disable-line @typescript-eslint/ban-types
sidecar: Element, options: ShowOptions) => void;
export declare const registerEntityView: (kind: string, handler: ISidecarViewHandler) => void;
/**
 * Update the current view into the sidecar; this is helpful for tab
 * mode switching.
 *
 */
export declare const insertCustomContent: (tab: Tab, view: HTMLElement) => void;
