"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/bash-like/cmds/catchall');
exports.dispatchToShell = ({ tab, block, command, argvNoOptions, execOptions, parsedOptions, createOutputStream }) => __awaiter(void 0, void 0, void 0, function* () {
    const cleanUpError = (err) => {
        if (err.message && typeof err.message === 'string') {
            err.message = err.message.replace(/[a-zA-Z0-9/]+:\s*/, '').trim();
        }
        throw err;
    };
    const useRaw = (execOptions.raw || execOptions.type === core_1.ExecType.Nested) &&
        execOptions.quiet === undefined &&
        execOptions.echo === undefined &&
        execOptions.replSilence === undefined;
    const eOptions = useRaw || execOptions.isProxied
        ? execOptions
        : Object.assign({}, { stdout: yield createOutputStream() }, execOptions);
    const actualCommand = command.replace(/^(!|sendtopty)\s+/, '');
    if (core_1.isHeadless() || (!core_1.inBrowser() && useRaw)) {
        const { doExec } = yield Promise.resolve().then(() => require('./bash-like'));
        const response = yield doExec(actualCommand, eOptions).catch(cleanUpError);
        if (useRaw && typeof response === 'string') {
            try {
                return JSON.parse(response);
            }
            catch (err) {
                debug('response maybe is not JSON', response);
            }
        }
        return response;
    }
    else {
        const { doExec } = yield Promise.resolve().then(() => require('../../pty/client'));
        const exec = () => doExec(tab, block, actualCommand, argvNoOptions, parsedOptions, eOptions);
        if (useRaw) {
            eOptions.quiet = true;
            eOptions.echo = false;
            eOptions.replSilence = true;
            let response = '';
            eOptions.onInit = () => (_) => {
                if (typeof _ === 'string') {
                    response += _;
                }
            };
            return exec()
                .then(() => response)
                .catch(cleanUpError);
        }
        return exec().catch(cleanUpError);
    }
});
exports.preload = (commandTree) => {
    if (core_1.inBrowser() && !core_1.hasProxy()) {
        debug('skipping catchall registration: in browser and no remote proxy to support it');
        return;
    }
    return commandTree.catchall(() => true, exports.dispatchToShell, 0, { noAuthOk: true, inBrowserOk: true });
};
//# sourceMappingURL=catchall.js.map