"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const exportCommand = ({ tab, parsedOptions }) => {
    const curDic = core_1.SymbolTable.read(tab);
    const toBeParsed = parsedOptions._[1];
    const arr = toBeParsed.split('=');
    curDic[arr[0]] = arr[1];
    core_1.SymbolTable.write(tab, curDic);
    return true;
};
const usage = {
    command: 'export',
    strict: 'export',
    docs: 'Export a variable or function to the environment of all the child processes running in the current shell',
    required: [{ name: 'key=value', docs: 'an assignment of key to value' }]
};
exports.default = (commandTree) => {
    commandTree.listen('/export', exportCommand, { usage, noAuthOk: true, inBrowserOk: true });
};
//# sourceMappingURL=export.js.map