/// <reference types="node" />
import * as EventEmitter from 'events';
export interface Channel {
    isAlive?: boolean;
    close: () => void;
    send: (msg: string | Buffer) => void;
    on: (eventType: string, handler: any) => void;
    removeEventListener: (eventType: string, handler: any) => void;
    readyState: number;
}
export declare enum ReadyState {
    CONNECTING = 0,
    OPEN = 1,
    CLOSING = 2,
    CLOSED = 3
}
export declare class InProcessChannel extends EventEmitter implements Channel {
    readyState: ReadyState;
    private otherSide;
    constructor(otherSide?: InProcessChannel);
    init(): Promise<void>;
    close(): void;
    send(msg: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
export declare class WebViewChannelRendererSide extends EventEmitter implements Channel {
    readyState: ReadyState;
    private channelId;
    init(): Promise<void>;
    close(): void;
    send(body: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
