"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/bash-like/pty/channel');
class WebSocketChannel {
    constructor(url, uid, gid) {
        debug('WebSocketChannel init', url);
        this.ws = new WebSocket(url);
        this.uid = uid;
        this.gid = gid;
    }
    close() {
        debug('closing websocket channel');
        this.ws.close();
    }
    send(msg) {
        const withUser = Object.assign(JSON.parse(msg), {
            uid: this.uid,
            gid: this.gid
        });
        return this.ws.send(JSON.stringify(withUser));
    }
    get readyState() {
        return this.ws.readyState;
    }
    removeEventListener(eventType, handler) {
        this.ws.removeEventListener(eventType, handler);
    }
    on(eventType, handler) {
        switch (eventType) {
            case 'open':
                debug('WebSocketChannel: installing onopen handler');
                this.ws.addEventListener(eventType, handler);
                break;
            case 'message':
                debug('WebSocketChannel: installing onmessage handler');
                this.ws.addEventListener(eventType, message => handler(message.data));
                break;
            case 'error':
                debug('WebSocketChannel: installing onerror handler');
                this.ws.addEventListener(eventType, handler);
                break;
            case 'close':
                debug('WebSocketChannel: installing onclose handler');
                this.ws.addEventListener(eventType, handler);
                break;
        }
    }
}
exports.default = WebSocketChannel;
//# sourceMappingURL=websocket-channel.js.map