/// <reference types="node" />
import * as EventEmitter from 'events';
export interface Channel {
    /** is the channel alive? */
    isAlive?: boolean;
    /** Forcibly close the channel */
    close: () => void;
    /** Send a message over the channel */
    send: (msg: string | Buffer) => void;
    on: (eventType: string, handler: any) => void;
    removeEventListener: (eventType: string, handler: any) => void;
    readyState: number;
}
export declare enum ReadyState {
    CONNECTING = 0,
    OPEN = 1,
    CLOSING = 2,
    CLOSED = 3
}
/**
 * Channel impl for direct, in-electron communication
 *
 */
export declare class InProcessChannel extends EventEmitter implements Channel {
    readyState: ReadyState;
    private otherSide;
    constructor(otherSide?: InProcessChannel);
    init(): Promise<void>;
    /** Forcibly close the channel */
    close(): void;
    /** emit 'message' on the other side */
    send(msg: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
/**
 * Thin wrapper on top of WebView postMessage
 *
 */
export declare class WebViewChannelRendererSide extends EventEmitter implements Channel {
    readyState: ReadyState;
    private channelId;
    init(): Promise<void>;
    /** Forcibly close the channel */
    close(): void;
    /** emit 'message' on the other side */
    send(body: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
