/// <reference types="node" />
import * as EventEmitter from 'events';
import { ChildProcess } from 'child_process';
import { ExitHandler } from './server';
import { Channel, ReadyState } from './channel';
/**
 * stdin/stdout channel
 *
 */
export declare class StdioChannelWebsocketSide extends EventEmitter implements Channel {
    readyState: ReadyState;
    private ws;
    private readonly wss;
    constructor(wss: EventEmitter);
    init(child: ChildProcess, pollInterval?: number): Promise<void>;
    /** Forcibly close the channel */
    close(): void;
    /** emit 'message' on the other side */
    send(msg: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
/**
 * stdin/stdout channel
 *
 */
export declare class StdioChannelKuiSide extends EventEmitter implements Channel {
    readyState: ReadyState;
    init(onExit: ExitHandler): Promise<void>;
    /** Forcibly close the channel */
    close(): void;
    /** emit 'message' on the other side */
    send(msg: string): void;
    removeEventListener(eventType: string, handler: any): void;
}
