"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
exports.default = (commandTree) => {
    commandTree.subtree('/window', {
        docs: 'Window sizing commands, e.g. "window max" and "window unmax"'
    });
    commandTree.listen('/window/max', () => core_1.tellMain('maximize-window'), {
        docs: 'Maximize the window',
        noAuthOk: true
    });
    commandTree.listen('/window/unmax', () => core_1.tellMain('unmaximize-window'), {
        docs: 'Unmaximize the window',
        noAuthOk: true
    });
    commandTree.listen('/window/close', () => {
        if (core_1.inBrowser()) {
            throw new Error('Unsupported operation');
        }
        else {
            const remote = require('electron').remote;
            const w = remote.getCurrentWindow();
            w.close();
            return true;
        }
    }, { noAuthOk: true });
};
//# sourceMappingURL=window.js.map