"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const minimist = require("yargs-parser");
const fs_1 = require("fs");
const path_1 = require("path");
const registrar_1 = require("./registrar");
var registrar_2 = require("./registrar");
exports.registerTabCompletionEnumerator = registrar_2.registerEnumerator;
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/core-support/tab completion');
const listenForUpDown = (prompt) => {
    const moveTo = (nextOp, evt) => {
        const block = core_1.getCurrentBlock();
        const temporaryContainer = block && block.querySelector('.tab-completion-temporary');
        if (temporaryContainer) {
            const current = temporaryContainer.querySelector('.selected');
            if (current) {
                const next = current[nextOp];
                if (next) {
                    current.classList.remove('selected');
                    next.classList.add('selected');
                    next.scrollIntoView();
                    evt.preventDefault();
                }
            }
        }
    };
    const previousKeyDown = prompt.onkeydown;
    prompt.onkeydown = evt => {
        const char = evt.keyCode;
        if (char === core_1.KeyCodes.DOWN) {
            moveTo('nextSibling', evt);
        }
        else if (char === core_1.KeyCodes.UP) {
            moveTo('previousSibling', evt);
        }
        else if (char === core_1.KeyCodes.C && evt.ctrlKey) {
            core_1.doCancel();
        }
    };
    return () => {
        prompt.onkeydown = previousKeyDown;
    };
};
const listenForEscape = () => {
    const previousKeyup = document.onkeyup;
    const cleanup = () => {
        document.onkeyup = previousKeyup;
    };
    document.onkeyup = evt => {
        if (evt.keyCode === core_1.KeyCodes.ESCAPE) {
            const block = core_1.getCurrentBlock();
            const temporaryContainer = block && block.querySelector('.tab-completion-temporary');
            if (temporaryContainer) {
                evt.preventDefault();
                temporaryContainer.cleanup();
            }
        }
    };
    return cleanup;
};
const installKeyHandlers = (prompt) => {
    if (prompt) {
        return [listenForUpDown(prompt), listenForEscape()];
    }
    else {
        return [];
    }
};
const makeCompletionContainer = (block, prompt, partial, dirname, lastIdx) => {
    const temporaryContainer = document.createElement('div');
    temporaryContainer.className = 'tab-completion-temporary repl-temporary';
    const scrollContainer = document.createElement('div');
    scrollContainer.className = 'tab-completion-scroll-container';
    temporaryContainer.appendChild(scrollContainer);
    temporaryContainer.scrollContainer = scrollContainer;
    if (!process.env.RUNNING_SHELL_TEST) {
        temporaryContainer.classList.add('fade-in');
    }
    temporaryContainer.partial = partial;
    temporaryContainer.dirname = dirname;
    temporaryContainer.lastIdx = lastIdx;
    temporaryContainer.currentMatches = [];
    block.appendChild(temporaryContainer);
    const handlers = installKeyHandlers(prompt);
    const onChange = () => {
        if (!prompt.value.endsWith(partial)) {
            return temporaryContainer.cleanup();
        }
        const args = core_1.split(prompt.value);
        const currentText = args[temporaryContainer.lastIdx];
        const prevMatches = temporaryContainer.currentMatches;
        const newMatches = prevMatches.filter(({ match }) => match.indexOf(currentText) === 0);
        const removedMatches = prevMatches.filter(({ match }) => match.indexOf(currentText) !== 0);
        temporaryContainer.currentMatches = newMatches;
        removedMatches.forEach(({ option }) => temporaryContainer.removeChild(option));
        temporaryContainer['partial'] = currentText;
        if (temporaryContainer.currentMatches.length === 0) {
            temporaryContainer.cleanup();
        }
    };
    prompt.addEventListener('input', onChange);
    temporaryContainer.cleanup = () => {
        try {
            block.removeChild(temporaryContainer);
        }
        catch (err) {
        }
        try {
            handlers.forEach(cleanup => cleanup());
        }
        catch (err) {
        }
        prompt.removeEventListener('input', onChange);
    };
    setTimeout(() => block.scrollIntoView(), 0);
    return temporaryContainer;
};
exports.shellescape = (str) => {
    return str.replace(/ /g, '\\ ');
};
exports.isDirectory = (filepath) => new Promise((resolve, reject) => {
    fs_1.lstat(filepath, (err, stats) => {
        if (err) {
            reject(err);
        }
        else {
            if (stats.isSymbolicLink()) {
                debug('following symlink');
                return fs_1.realpath(filepath, (err, realpath) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        exports.isDirectory(realpath)
                            .then(resolve)
                            .catch(reject);
                    }
                });
            }
            resolve(stats.isDirectory());
        }
    });
}).catch(err => {
    if (err.code === 'ENOENT') {
        return false;
    }
    else {
        throw err;
    }
});
const complete = (match, prompt, lastIdx, options) => {
    const temporaryContainer = options.temporaryContainer;
    const dirname = options.dirname || (temporaryContainer && temporaryContainer.dirname);
    const addSpace = (lastIdx === undefined || lastIdx >= prompt.value.length - 1) && (options.addSpace || false);
    const completion = exports.shellescape(match.slice((options.temporaryContainer && options.temporaryContainer.already) || 0)) +
        (addSpace ? ' ' : '');
    debug('completion', lastIdx, prompt.value.length, addSpace, match, completion, options.temporaryContainer && options.temporaryContainer.already);
    if (temporaryContainer) {
        temporaryContainer.cleanup();
    }
    const addToPrompt = (extra) => {
        prompt.value = prompt.value.slice(0, lastIdx) + extra + prompt.value.slice(lastIdx);
        prompt.selectionStart = lastIdx + extra.length;
        prompt.selectionEnd = prompt.selectionStart;
        prompt.scrollLeft = prompt.scrollWidth;
    };
    if (dirname) {
        const filepath = core_1.expandHomeDir(path_1.join(dirname, match));
        exports.isDirectory(filepath)
            .then(isDir => {
            if (isDir) {
                debug('complete as directory');
                addToPrompt(completion + '/');
            }
            else {
                debug('complete as scalar');
                addToPrompt(completion);
            }
        })
            .catch(err => {
            console.error(err);
        });
    }
    else {
        debug('complete as scalar (alt)');
        addToPrompt(completion);
    }
};
const addSuggestion = (temporaryContainer, prefix, lastIdx, dirname, prompt, doEscape = false) => (match, idx) => {
    const matchLabel = registrar_1.isStringResponse(match) ? match : match.label || match.completion;
    const matchCompletion = registrar_1.isStringResponse(match) ? match : match.completion || match.label;
    const addSpace = !registrar_1.isStringResponse(match) && match.addSpace;
    const option = document.createElement('div');
    const optionInnerFill = document.createElement('span');
    const optionInner = document.createElement('a');
    const innerPre = document.createElement('span');
    const innerPost = document.createElement('span');
    optionInner.appendChild(innerPre);
    optionInner.appendChild(innerPost);
    temporaryContainer.scrollContainer.appendChild(option);
    option.appendChild(optionInnerFill);
    optionInnerFill.appendChild(optionInner);
    optionInnerFill.className = 'tab-completion-temporary-fill';
    innerPre.innerText = prefix;
    innerPost.innerText = matchLabel.replace(new RegExp(`^${prefix}`), '');
    if (!registrar_1.isStringResponse(match) && match.docs) {
        const optionDocs = document.createElement('span');
        optionDocs.className = 'deemphasize deemphasize-partial left-pad';
        option.appendChild(optionDocs);
        optionDocs.innerText = `(${match.docs})`;
    }
    option.className = 'tab-completion-option';
    optionInner.className = 'clickable plain-anchor';
    innerPre.classList.add('tab-completion-option-pre');
    innerPost.classList.add('tab-completion-option-post');
    if (idx === 0) {
        option.classList.add('selected');
    }
    option.addEventListener('click', function () {
        const completion = this.getAttribute('data-completion');
        const doEscape = this.hasAttribute('data-do-escape');
        const addSpace = this.hasAttribute('data-add-space');
        complete(completion, prompt, prompt.selectionStart, {
            temporaryContainer,
            dirname,
            doEscape,
            addSpace
        });
    });
    option.setAttribute('data-match', matchLabel);
    option.setAttribute('data-completion', doEscape ? exports.shellescape(matchCompletion) : matchCompletion);
    if (addSpace)
        option.setAttribute('data-add-space', addSpace.toString());
    if (doEscape)
        option.setAttribute('data-do-escape', 'true');
    option.setAttribute('data-value', optionInner.innerText);
    temporaryContainer.currentMatches.push({
        match: matchLabel,
        completion: matchCompletion,
        option
    });
    return { option, optionInner, innerPost };
};
const updateReplToReflectLongestPrefix = (prompt, lastIdx, matches, temporaryContainer, partial = temporaryContainer.partial) => {
    if (matches.length > 0) {
        const shortest = matches.reduce((minLength, match) => (!minLength ? match.length : Math.min(minLength, match.length)), false);
        let idx = 0;
        const partialComplete = (idx) => {
            const extra = exports.shellescape(matches[0].substring(0, idx));
            const completion = partial + extra;
            temporaryContainer.partial = completion;
            temporaryContainer.lastIdx = lastIdx + extra.length;
            temporaryContainer.already = extra.length;
            prompt.value = prompt.value.slice(0, lastIdx) + extra + prompt.value.slice(lastIdx);
            prompt.selectionStart = lastIdx + extra.length;
            prompt.selectionEnd = prompt.selectionStart;
            return temporaryContainer.partial;
        };
        for (idx = 0; idx < shortest; idx++) {
            const char = matches[0].charAt(idx);
            for (let jdx = 1; jdx < matches.length; jdx++) {
                const other = matches[jdx].charAt(idx);
                if (char !== other) {
                    if (idx > 0) {
                        return partialComplete(idx);
                    }
                    else {
                        return;
                    }
                }
            }
        }
        if (idx > 0) {
            return partialComplete(idx);
        }
    }
};
const presentEnumeratorSuggestions = (block, prompt, temporaryContainer, lastIdx, last) => (filteredList) => {
    debug('presentEnumeratorSuggestions', filteredList);
    if (filteredList.length === 1) {
        const { completion, addSpace } = !registrar_1.isStringResponse(filteredList[0])
            ? filteredList[0]
            : { completion: filteredList[0], addSpace: false };
        complete(completion, prompt, prompt.selectionStart, { partial: last, dirname: false, addSpace, doEscape: true });
    }
    else if (filteredList.length > 0) {
        const partial = last;
        const dirname = undefined;
        if (!temporaryContainer) {
            temporaryContainer = makeCompletionContainer(block, prompt, partial, dirname, lastIdx);
        }
        const stringList = filteredList.map(_ => (registrar_1.isStringResponse(_) ? _ : _.completion));
        updateReplToReflectLongestPrefix(prompt, lastIdx, stringList, temporaryContainer);
        filteredList.forEach(addSuggestion(temporaryContainer, last, lastIdx, dirname, prompt, true));
    }
};
const suggestCommandCompletions = (_matches, partial, lastIdx, block, prompt, temporaryContainer) => {
    const matches = _matches
        .filter(({ usage, docs }) => usage || docs)
        .map(({ command, docs, usage = {
        command,
        docs,
        commandPrefix: undefined,
        title: undefined,
        header: undefined
    } }) => ({
        label: command,
        completion: command.substring(partial.length),
        addSpace: true,
        docs: usage.title || usage.header || usage.docs
    }));
    if (matches.length === 1) {
        debug('singleton command completion', matches[0]);
        complete(matches[0].completion, prompt, prompt.selectionStart, {
            partial,
            dirname: false,
            addSpace: matches[0].addSpace
        });
    }
    else if (matches.length > 0) {
        debug('suggesting command completions', matches, partial);
        if (!temporaryContainer) {
            temporaryContainer = makeCompletionContainer(block, prompt, partial);
        }
        matches.forEach(addSuggestion(temporaryContainer, partial, lastIdx, undefined, prompt));
    }
};
exports.default = () => {
    if (typeof document === 'undefined')
        return;
    core_1.injectCSS({
        css: require('@kui-shell/plugin-core-support/web/css/tab-completion.css'),
        key: 'plugin-core-support.kui-shell.org/tab-completion.css'
    });
    let currentEnumeratorAsync;
    document.addEventListener('keydown', (evt) => __awaiter(void 0, void 0, void 0, function* () {
        const block = core_1.getCurrentBlock();
        const tab = core_1.getTabFromTarget(block);
        const temporaryContainer = block && block.querySelector('.tab-completion-temporary');
        if (evt.keyCode === core_1.KeyCodes.ENTER) {
            if (temporaryContainer) {
                const current = temporaryContainer.querySelector('.selected');
                if (current) {
                    const completion = current.getAttribute('data-completion');
                    const doEscape = current.hasAttribute('data-do-escape');
                    const addSpace = current.hasAttribute('data-add-space');
                    const prompt = core_1.getCurrentPrompt();
                    complete(completion, prompt, prompt.selectionStart, {
                        temporaryContainer,
                        doEscape,
                        addSpace
                    });
                }
                evt.preventDefault();
                try {
                    temporaryContainer.cleanup();
                }
                catch (err) {
                }
            }
        }
        else if (evt.keyCode === core_1.KeyCodes.TAB) {
            const prompt = core_1.getCurrentPrompt();
            if (prompt) {
                if (core_1.isUsingCustomPrompt(prompt)) {
                    evt.preventDefault();
                    return true;
                }
                const value = prompt.value;
                if (value) {
                    evt.preventDefault();
                    if (temporaryContainer) {
                        const current = temporaryContainer.querySelector('.selected');
                        const next = (current.nextSibling ||
                            temporaryContainer.querySelector('.tab-completion-option:first-child'));
                        if (next) {
                            current.classList.remove('selected');
                            next.classList.add('selected');
                            next.scrollIntoView();
                        }
                        return;
                    }
                    const handleUsage = (usageError) => {
                        const usage = usageError.raw ? usageError.raw.usage || usageError.raw : usageError.usage || usageError;
                        debug('usage', usage, usageError);
                        if (usage.fn) {
                            debug('resolving generator');
                            handleUsage(usage.fn(usage.command));
                        }
                        else if (usageError.partialMatches || usageError.available) {
                            suggestCommandCompletions(usageError.partialMatches || usageError.available, prompt.value, prompt.value.length - 1, block, prompt, temporaryContainer);
                        }
                        else if (usage && usage.command) {
                            const required = usage.required || [];
                            const optionalPositionals = (usage.optional || []).filter(({ positional }) => positional);
                            const oneofs = usage.oneof ? [usage.oneof[0]] : [];
                            const positionals = required.concat(oneofs).concat(optionalPositionals);
                            debug('positionals', positionals);
                            if (positionals.length > 0) {
                                const args = core_1.split(prompt.value).filter(_ => !/^-/.test(_));
                                const commandIdx = args.indexOf(usage.command);
                                const nActuals = args.length - commandIdx - 1;
                                const lastIdx = Math.max(0, nActuals - 1);
                                const param = positionals[lastIdx];
                                debug('maybe', args, commandIdx, lastIdx, nActuals, param, args[commandIdx + lastIdx]);
                                if (commandIdx === args.length - 1 && !prompt.value.match(/\s+$/)) {
                                }
                            }
                        }
                    };
                    const lastIdx = prompt.selectionStart;
                    const { A: argv, endIndices } = core_1._split(prompt.value, true, true);
                    const options = minimist(argv);
                    const toBeCompletedIdx = endIndices.findIndex(idx => idx >= lastIdx);
                    const completingTrailingEmpty = lastIdx > endIndices[endIndices.length - 1];
                    if (toBeCompletedIdx >= 0 || completingTrailingEmpty) {
                        const last = completingTrailingEmpty
                            ? ''
                            : prompt.value.substring(endIndices[toBeCompletedIdx - 1], lastIdx).replace(/^\s+/, '');
                        const argvNoOptions = options._;
                        delete options._;
                        const commandLine = {
                            command: prompt.value,
                            argv,
                            argvNoOptions,
                            parsedOptions: options
                        };
                        const spec = {
                            toBeCompletedIdx,
                            toBeCompleted: last
                        };
                        const gotSomeCompletions = yield new Promise(resolve => {
                            if (currentEnumeratorAsync) {
                                clearTimeout(currentEnumeratorAsync);
                            }
                            const myEnumeratorAsync = setTimeout(() => __awaiter(void 0, void 0, void 0, function* () {
                                const completions = yield registrar_1.applyEnumerator(tab, commandLine, spec);
                                if (myEnumeratorAsync !== currentEnumeratorAsync) {
                                    return;
                                }
                                if (completions && completions.length > 0) {
                                    presentEnumeratorSuggestions(block, prompt, temporaryContainer, lastIdx, last)(completions);
                                    currentEnumeratorAsync = undefined;
                                    resolve(true);
                                }
                                else {
                                    resolve(false);
                                }
                            }));
                            currentEnumeratorAsync = myEnumeratorAsync;
                        });
                        if (gotSomeCompletions) {
                            return;
                        }
                    }
                    try {
                        debug('fetching usage', value);
                        const tab = core_1.getTabFromTarget(block);
                        const usage = tab.REPL.qexec(`${value} --help`, undefined, undefined, {
                            failWithUsage: true
                        });
                        if (usage.then) {
                            usage.then(handleUsage, handleUsage);
                        }
                        else {
                            handleUsage(usage);
                        }
                    }
                    catch (err) {
                        console.error(err);
                    }
                }
            }
        }
    }));
};
//# sourceMappingURL=index.js.map