"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
function isStringResponse(response) {
    return response === undefined || typeof response === 'string';
}
exports.isStringResponse = isStringResponse;
const enumerators = [];
function registerEnumerator(enumerator) {
    enumerators.push(enumerator);
}
exports.registerEnumerator = registerEnumerator;
function applyEnumerator(tab, commandLine, spec) {
    return __awaiter(this, void 0, void 0, function* () {
        const lists = yield Promise.all(enumerators.map(_ => _(tab, commandLine, spec)));
        return core_1.flatten(lists.map(x => x)).filter(x => x);
    });
}
exports.applyEnumerator = applyEnumerator;
//# sourceMappingURL=registrar.js.map