import { Tab, CommandLine } from '@kui-shell/core';
/**
 * A registrar for enumerators
 *
 */
export interface TabCompletionSpec {
    /**
     * The prefix of the to-be-completed parameter that has been typed
     * so far.
     */
    toBeCompleted: string;
    /**
     * An index into CommandLine.argv, or -1 if it is the trailing
     * argument that is to be completed.
     */
    toBeCompletedIdx: number;
}
export declare type CompletionResponse = string | {
    completion: string;
    addSpace: boolean;
    docs?: string;
    label?: string;
};
export declare function isStringResponse(response: CompletionResponse): response is string;
declare type Enumerator = (tab: Tab, commandLine: CommandLine, spec: TabCompletionSpec) => CompletionResponse[] | Promise<CompletionResponse[]>;
export declare function registerEnumerator(enumerator: Enumerator): void;
export declare function applyEnumerator(tab: Tab, commandLine: CommandLine, spec: TabCompletionSpec): Promise<CompletionResponse[]>;
export {};
