"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const events_1 = require("events");
const core_1 = require("@kui-shell/core");
const theme_1 = require("./theme");
const file_types_1 = require("./file-types");
const debug = debug_1.default('plugins/editor/open');
const strings = core_1.i18n('plugin-editor');
let pre2 = false;
const setText = (editor, options, execOptions) => ({ code, kind }) => {
    const lang = (options && options.language) || file_types_1.language(kind);
    debug('setText language', kind, lang);
    debug('setText code', code.substring(0, 20));
    const oldModel = editor.getModel();
    const newModel = global['monaco'].editor.createModel(code, lang);
    editor.setModel(newModel);
    if (!execOptions || !execOptions.cursorPosition || execOptions.cursorPosition === 'end') {
        editor.setPosition(editor.getModel().getPositionAt((code && code.length) || 0));
    }
    if (oldModel) {
        oldModel.dispose();
    }
    return code;
};
exports.openEditor = (tab, name, options, execOptions) => __awaiter(void 0, void 0, void 0, function* () {
    debug('openEditor');
    const custom = execOptions.custom;
    const getEntityFn = (custom && custom.getEntity) || core_1.currentSelection;
    let currentEntity = getEntityFn(tab);
    const getEntity = () => currentEntity;
    const entityRightNow = currentEntity;
    const kind = entityRightNow && ((entityRightNow.exec && entityRightNow.exec.kind) || entityRightNow.contentType);
    if (kind === 'yaml' || kind === 'json') {
        options.showFoldingControls = 'always';
    }
    if (!pre2) {
        core_1.injectCSS({
            css: require('@kui-shell/plugin-editor/web/css/editor.css').toString(),
            key: 'editor.editor'
        });
        pre2 = true;
    }
    const content = document.createElement('div');
    const editorWrapper = document.createElement('div');
    editorWrapper.className = 'monaco-editor-wrapper';
    content.appendChild(editorWrapper);
    if (!options.readOnly) {
        editorWrapper.focus();
    }
    const theme = getComputedStyle(document.body);
    editorWrapper['baseFontSize'] = parseInt(theme.getPropertyValue('font-size').replace(/px$/, ''), 10) * 0.875;
    content.onclick = evt => {
        evt.stopPropagation();
    };
    theme_1.default();
    const makeUpdater = (editor) => {
        editor.updateText = (entity) => {
            return setText(editor, options)(entity.exec);
        };
        editor['clearDecorations'] = () => {
            const none = [{ range: new global['monaco'].Range(1, 1, 1, 1), options: {} }];
            editor['__cloudshell_decorations'] = editor.deltaDecorations(editor['__cloudshell_decorations'] || [], none);
        };
        editorWrapper['editor'] = editor;
        return (entity) => {
            debug('updater', entity);
            const eventBus = new events_1.EventEmitter();
            setText(editor, options, execOptions)(entity['exec']);
            content.classList.add('code-highlighting');
            currentEntity = entity;
            const status = document.createElement('div');
            const isNew = document.createElement('div');
            const isNewReadOnly = document.createElement('div');
            const upToDate = document.createElement('div');
            const modified = document.createElement('div');
            status.appendChild(isNew);
            status.appendChild(isNewReadOnly);
            status.appendChild(upToDate);
            status.appendChild(modified);
            isNew.innerHTML = strings('isNew');
            isNewReadOnly.innerHTML = strings('isNewReadOnly');
            upToDate.innerHTML = strings('isUpToDate');
            modified.innerHTML = strings('isModified');
            status.className = 'editor-status';
            if (options.readOnly) {
                debug('status:is-read-only');
                status.classList.add('is-read-only');
            }
            if (entity['isNew']) {
                debug('status:is-new');
                status.classList.add('is-new');
            }
            else {
                debug('status:is-up-to-date');
                status.classList.add('is-up-to-date');
            }
            isNew.className = 'is-new';
            isNewReadOnly.className = 'is-new-read-only';
            upToDate.className = 'is-up-to-date';
            modified.className = 'is-modified';
            const toolbarText = new core_1.ToolbarText('info', status);
            const updateHeader = (isModified) => {
                if (!execOptions.noSidecarHeader) {
                    debug('updateHeader', isModified, currentEntity);
                    toolbarText.type = isModified ? 'warning' : 'info';
                    status.classList.remove('is-modified');
                    status.classList.remove('is-up-to-date');
                    status.classList.remove('is-new');
                    if (currentEntity.isNew) {
                        status.classList.add('is-new');
                    }
                    else if (isModified) {
                        status.classList.add('is-modified');
                    }
                    else {
                        status.classList.add('is-up-to-date');
                    }
                    toolbarText.refresh();
                }
            };
            const editsInProgress = () => {
                debug('editsInProgress');
                editor['clearDecorations']();
                eventBus.emit('/editor/change', {});
                updateHeader(true);
            };
            const editsCommitted = (entity, opts) => {
                debug('editsCommited', opts, entity);
                status.classList.remove('is-new');
                entity.persister = currentEntity.persister;
                currentEntity = entity;
                debug('status:is-up-to-date');
                updateHeader(false);
                if (opts.event === 'revert') {
                    editor.getModel().onDidChangeContent(editsInProgress);
                }
            };
            eventBus.on('/editor/save', editsCommitted);
            editor.getModel().onDidChangeContent(editsInProgress);
            updateHeader(false);
            return Promise.resolve({ getEntity, editor, content, tab, eventBus, toolbarText });
        };
    };
    const initEditor = (yield Promise.resolve().then(() => require('./init/esm'))).default;
    return initEditor(editorWrapper, options).then(makeUpdater);
});
exports.default = exports.openEditor;
//# sourceMappingURL=open.js.map