"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/editor/readonly');
exports.gotoReadonlyLocalFile = ({ getEntity }) => (tab) => __awaiter(void 0, void 0, void 0, function* () {
    const entity = yield getEntity(tab);
    debug('readonly', entity.name, entity);
    return tab.REPL.pexec(`open ${tab.REPL.encodeComponent(entity.filepath)}`);
});
exports.edit = ({ getEntity, lock = undefined }) => (tab) => __awaiter(void 0, void 0, void 0, function* () {
    const { namespace, name } = yield getEntity(tab);
    return tab.REPL.qexec(`edit "/${namespace}/${name}"`, undefined, undefined, {
        custom: { getEntity, lock }
    });
});
exports.lockIcon = ({ getEntity, mode = 'lock', label = 'Done Editing', tooltip = 'Return to read-only mode', command = exports.gotoReadonlyLocalFile({ getEntity }) }) => ({
    mode,
    label,
    flush: 'weak',
    actAsButton: true,
    balloon: tooltip,
    command,
    kind: 'drilldown'
});
//# sourceMappingURL=readonly.js.map