/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { registerEditor, Presentation, isResourceByReference } from '@kui-shell/core';
class MonacoEditorProvider {
    tryOpen(tab, custom, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const { edit } = yield import(/* webpackMode: "lazy" */ './cmds/edit');
            const projection = custom.content;
            const metadataBearer = isResourceByReference(custom) ? custom.resource : custom;
            const entity = {
                // EditorEntity
                type: custom.prettyType,
                name: metadataBearer.metadata.name,
                kind: metadataBearer.kind,
                metadata: metadataBearer.metadata,
                noZoom: custom.noZoom,
                //      persister: () => true,
                annotations: [],
                exec: {
                    kind: custom.contentType,
                    code: typeof projection !== 'string' ? JSON.stringify(projection, undefined, 2) : projection
                }
            };
            const { content } = yield edit(tab, entity, { readOnly: true }, options);
            return {
                content,
                presentation: Presentation.FixedSize
            };
        });
    }
}
export default function register() {
    registerEditor(new MonacoEditorProvider());
}
//# sourceMappingURL=editor-provider.js.map