import { Tab, ParsedOptions, ExecOptions } from '@kui-shell/core';
import Entity from './entity';
export declare type IFetcher = (tab: Tab, entityName: string, parsedOptions?: ParsedOptions, execOptions?: ExecOptions, createIfAbsent?: boolean) => Promise<Entity>;
export declare const registerFetcher: (fetcher: IFetcher) => void;
/**
 * Read a local file, optionally creating it
 *
 */
export declare const fetchFile: IFetcher;
/**
 * See if we one of the registered entity fetchers knows how to fetch
 * the text for the given named entity
 *
 */
export declare const fetchEntity: (tab: Tab, entityName: string, parsedOptions: ParsedOptions, execOptions: ExecOptions) => Promise<Entity>;
