"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const exec_1 = require("./exec");
const help_1 = require("./help");
const command_prefix_1 = require("../command-prefix");
const isHelm = (str) => /^helm$/.test(str);
exports.default = (registrar) => {
    if (core_1.inBrowser() && !core_1.hasProxy()) {
        return;
    }
    registrar.catchall((argv) => {
        return isHelm(argv[0]) || (argv[0] === command_prefix_1.default && isHelm(argv[1]));
    }, (args) => __awaiter(void 0, void 0, void 0, function* () {
        return help_1.doHelpIfRequested(args, yield exec_1.default(args));
    }), 1, { inBrowserOk: true });
};
//# sourceMappingURL=catchall.js.map