"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const plugin_kubeui_1 = require("@kui-shell/plugin-kubeui");
const command_prefix_1 = require("../command-prefix");
const isPlainHelm = (args) => (args.argvNoOptions.length === 1 && /^helm$/.test(args.argvNoOptions[0])) ||
    (args.argvNoOptions.length === 2 && args.argvNoOptions[0] === command_prefix_1.default && /^helm$/.test(args.argvNoOptions[1]));
function isUsage(args) {
    return (args.parsedOptions.help ||
        args.parsedOptions.h ||
        isPlainHelm(args) ||
        args.argvNoOptions[1] === 'help' ||
        (args.argvNoOptions[0] === command_prefix_1.default && args.argvNoOptions[2] === 'help'));
}
exports.isUsage = isUsage;
function doHelp(response) {
    throw plugin_kubeui_1.renderHelp(response, 'helm', 'get', 500);
}
exports.doHelp = doHelp;
function doHelpIfRequested(args, response) {
    if (isUsage(args)) {
        doHelp(response);
    }
    else {
        return response;
    }
}
exports.doHelpIfRequested = doHelpIfRequested;
//# sourceMappingURL=help.js.map