var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import doExecWithStdout from './exec';
import { doHelp, isUsage } from './help';
import commandPrefix from '../command-prefix';
const name = /^NAME:\s+([\w-]+)/;
function doInstall(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield doExecWithStdout(args);
        if (isUsage(args)) {
            doHelp(response);
        }
        else {
            const releaseName = response.match(name)[1];
            return args.REPL.qexec(`helm get ${args.REPL.encodeComponent(releaseName)}`).catch(err => {
                console.error('error in helm get for helm install', err);
                return response;
            });
        }
    });
}
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/helm/install`, doInstall, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=install.js.map