"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const flags_1 = require("./flags");
const apiVersion_1 = require("./apiVersion");
const command_prefix_1 = require("../command-prefix");
const exec_1 = require("./exec");
const strings = core_1.i18n('plugin-kubeui');
const usage = {
    context: (command) => ({
        command,
        strict: command,
        docs: 'Print your current kubernetes context',
        example: 'kubectl context'
    }),
    contexts: (command) => ({
        command,
        strict: command,
        docs: 'List your available kubernetes contexts',
        example: 'kubectl contexts'
    })
};
const addClickHandlers = (table, { REPL }, execOptions) => {
    const body = table.body.map(row => {
        const nameAttr = row.attributes.find(({ key }) => key === 'NAME');
        const { value: contextName } = nameAttr;
        nameAttr.outerCSS += ' entity-name-group-narrow';
        const onclick = () => __awaiter(void 0, void 0, void 0, function* () {
            yield REPL.qexec(`kubectl config use-context ${REPL.encodeComponent(contextName)}`, undefined, undefined, Object.assign({}, execOptions, { raw: true }));
            row.setSelected();
        });
        row.name = contextName;
        row.onclick = onclick;
        nameAttr.onclick = onclick;
        return row;
    });
    return new core_1.Table({
        header: table.header,
        body: body,
        title: strings('contextsTableTitle')
    });
};
function valueOf(key, row) {
    const cell = row.attributes.find(_ => _.key === key);
    return cell ? cell.value : '';
}
function getCurrentContext(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        const [currentContextName, { content: contexts }] = yield Promise.all([
            tab.REPL.qexec(`context`),
            tab.REPL.rexec(`contexts`)
        ]);
        return contexts.find(_ => _.metadata.name === currentContextName);
    });
}
exports.getCurrentContext = getCurrentContext;
const listContexts = (args) => __awaiter(void 0, void 0, void 0, function* () {
    const execOptions = Object.assign({}, args.execOptions, { render: false });
    const contexts = yield args.REPL.qexec(`kubectl config get-contexts`, undefined, undefined, execOptions);
    if (args.execOptions.raw) {
        return {
            mode: 'raw',
            content: contexts.body.map(_ => ({
                apiVersion: apiVersion_1.default,
                kind: 'Context',
                originatingCommand: args.command,
                metadata: {
                    name: valueOf('NAME', _),
                    namespace: valueOf('NAMESPACE', _)
                },
                spec: {
                    user: valueOf('AUTHINFO', _),
                    cluster: valueOf('CLUSTER', _)
                }
            }))
        };
    }
    else {
        return addClickHandlers(contexts, args, execOptions);
    }
});
exports.default = (commandTree) => {
    commandTree.listen(`/${command_prefix_1.default}/kubectl/config/get-contexts`, exec_1.doExecWithTable, flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/context`, ({ REPL }) => __awaiter(void 0, void 0, void 0, function* () {
        return (yield REPL.qexec('kubectl config current-context')).trim();
    }), Object.assign({
        usage: usage.context('context')
    }, flags_1.default));
    commandTree.listen(`/${command_prefix_1.default}/contexts`, listContexts, Object.assign({
        usage: usage.contexts('contexts')
    }, flags_1.default));
};
//# sourceMappingURL=contexts.js.map