"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const states_1 = require("../../lib/model/states");
const verbs = ['create', 'apply'];
exports.doCreate = (verb, command = 'kubectl') => exec_1.doExecWithStatus(verb, states_1.FinalState.OnlineLike, command);
exports.default = (registrar) => {
    verbs.forEach(verb => {
        const handler = exports.doCreate(verb);
        registrar.listen(`/${command_prefix_1.default}/kubectl/${verb}`, handler, flags_1.default);
        registrar.listen(`/${command_prefix_1.default}/k/${verb}`, handler, flags_1.default);
    });
};
//# sourceMappingURL=create.js.map