"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function versionOf(apiVersion) {
    const [group, version] = apiVersion.split('/');
    if (!version) {
        return { group: '', version: '' };
    }
    else {
        return { group, version };
    }
}
exports.versionOf = versionOf;
function versionString(apiVersion) {
    const { group, version } = versionOf(apiVersion);
    return group.length > 0 ? `.${version}.${group}` : '';
}
function fqn(apiVersion, kind, name, namespace) {
    return `${kind}${versionString(apiVersion)} ${namespace === '<none>' ? '' : `-n ${namespace}`} ${name}`;
}
exports.fqn = fqn;
function fqnOf(resource) {
    return fqn(resource.apiVersion, resource.kind, resource.metadata.name, resource.metadata.namespace);
}
exports.fqnOf = fqnOf;
function fqnOfRef({ group, version, kind, name, namespace }) {
    return `${kind}${group ? `.${version}.${group}` : ''} ${namespace === '<none>' ? '' : `-n ${namespace}`} ${name}`;
}
exports.fqnOfRef = fqnOfRef;
exports.default = fqn;
//# sourceMappingURL=fqn.js.map