"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const flags_1 = require("./flags");
const contexts_1 = require("./contexts");
const command_prefix_1 = require("../command-prefix");
const get_1 = require("./get");
const options_1 = require("./options");
const kubectl_json_1 = require("@kui-shell/client/config.d/kubectl.json");
function doGetNamespaceTable(command, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const [baseTable, { metadata: { namespace: currentNamespace } }] = yield Promise.all([get_1.doGetAsTable(command, args, yield get_1.rawGet(args)), contexts_1.getCurrentContext(args.tab)]);
        if (core_1.isTable(baseTable)) {
            const augmentedTable = Object.assign({}, baseTable, {
                title: 'Namespaces',
                header: {
                    name: '',
                    css: baseTable.header.css,
                    outerCSS: `${baseTable.header.outerCSS} not-a-name`,
                    attributes: [
                        {
                            key: baseTable.header.key,
                            value: baseTable.header.name,
                            css: baseTable.header.css,
                            outerCSS: baseTable.header.outerCSS
                        }
                    ].concat(baseTable.header.attributes)
                },
                body: baseTable.body.map(row => {
                    const ns = row.name;
                    const isSelected = ns === currentNamespace;
                    const nameAttr = {
                        key: 'NAME',
                        value: ns,
                        outerCSS: 'entity-name-group',
                        css: 'entity-name',
                        onclick: `${command} get ns ${ns} -o yaml`
                    };
                    const newRow = {
                        key: 'NAME',
                        css: 'selected-entity',
                        name: isSelected ? '*' : '',
                        fontawesome: 'fas fa-check',
                        attributes: [nameAttr].concat(row.attributes),
                        outerCSS: 'not-a-name',
                        rowCSS: isSelected ? 'selected-row' : ''
                    };
                    newRow.onclick = () => {
                        newRow.setSelected();
                        args.REPL.pexec(`namespace switch ns ${ns}`);
                    };
                    return newRow;
                })
            });
            const rowIdxForDefaultNS = baseTable.body.findIndex(_ => _.name === 'default');
            if (rowIdxForDefaultNS >= 0 && baseTable.body.length > 1) {
                const lastRow = augmentedTable.body[augmentedTable.body.length - 1];
                augmentedTable.body[augmentedTable.body.length - 1] = augmentedTable.body[rowIdxForDefaultNS];
                augmentedTable.body[rowIdxForDefaultNS] = lastRow;
            }
            return augmentedTable;
        }
        else {
            return baseTable;
        }
    });
}
const doGetNamespace = (command) => (args) => {
    if (options_1.isTableRequest(args) && !options_1.isWatchRequest(args) && args.execOptions.type !== core_1.ExecType.Nested) {
        return doGetNamespaceTable(command, args);
    }
    else {
        return get_1.doGet(command)(args);
    }
};
function doSummarizeNamedNamespace(tab, ns) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield tab.REPL.qexec(`kubectl get all -n ${ns} -o custom-columns=KIND:.kind`);
        const resources = response.body;
        const histogram = resources.reduce((M, { name: kind }) => {
            M[kind] = (M[kind] || 0) + 1;
            return M;
        }, {});
        const header = {
            name: 'KIND',
            attributes: [{ key: 'COUNT', value: 'COUNT' }]
        };
        const body = Object.keys(histogram).map(kind => ({
            name: kind,
            onclick: `kubectl get ${kind} -n ${ns}`,
            attributes: [
                {
                    key: 'COUNT',
                    value: histogram[kind].toLocaleString()
                }
            ]
        }));
        return {
            header,
            body
        };
    });
}
exports.doSummarizeNamedNamespace = doSummarizeNamedNamespace;
function doSummarizeNamespace(args) {
    const ns = args.argvNoOptions[args.argvNoOptions.length - 1];
    return doSummarizeNamedNamespace(args.tab, ns);
}
function doSwitchNamespace(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const ns = args.argvNoOptions[args.argvNoOptions.length - 1];
        yield args.REPL.qexec(`kubectl config set-context --current --namespace=${ns}`);
        if (!kubectl_json_1.summarizeNamespaceOnSwitch) {
            return true;
        }
        return doSummarizeNamespace(args);
    });
}
function doGetCurrentNamespace({ tab }) {
    return __awaiter(this, void 0, void 0, function* () {
        return (yield contexts_1.getCurrentContext(tab)).metadata.namespace;
    });
}
exports.default = (commandTree) => {
    commandTree.listen(`/${command_prefix_1.default}/kubectl/get/namespaces`, doGetNamespace('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/get/namespaces`, doGetNamespace('k'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/kubectl/get/namespace`, doGetNamespace('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/get/namespace`, doGetNamespace('k'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/kubectl/get/ns`, doGetNamespace('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/get/ns`, doGetNamespace('k'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/namespace/current`, doGetCurrentNamespace, flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/namespace/summarize`, doSummarizeNamespace, flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/namespace/switch`, doSwitchNamespace, flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/ns/switch`, doSwitchNamespace, flags_1.default);
};
//# sourceMappingURL=get-namespaces.js.map