"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const get_watch_1 = require("./watch/get-watch");
const command_prefix_1 = require("../command-prefix");
const name_1 = require("../../lib/util/name");
const options_1 = require("./options");
const formatTable_1 = require("../../lib/view/formatTable");
function prepareArgsForGet(args) {
    const stripThese = ['-w=true', '--watch=true', '--watch-only=true', '-w', '--watch', '--watch-only'];
    const idx = args.command.indexOf(' get ') + ' get '.length;
    const pre = args.command.slice(0, idx - 1);
    const post = args.command.slice(idx - 1);
    return pre + stripThese.reduce((cmd, strip) => cmd.replace(new RegExp(`(\\s)${strip}`), '$1'), post);
}
function doGetAsTable(command, args, response, verb = 'get') {
    const { content: { stderr, stdout } } = response;
    const entityType = args.argvNoOptions[args.argvNoOptions.indexOf(verb) + 1];
    return formatTable_1.stringToTable(stdout, stderr, args, command, verb, entityType);
}
exports.doGetAsTable = doGetAsTable;
function doGetAsEntity(args, response) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const data = response.content.stdout;
            const resource = options_1.formatOf(args) === 'json' ? JSON.parse(data) : (yield Promise.resolve().then(() => require('js-yaml'))).safeLoad(data);
            const { name: prettyName, nameHash } = name_1.default(resource);
            if (resource.kind === 'List' && args.execOptions.type === core_1.ExecType.TopLevel) {
                return {
                    apiVersion: resource.apiVersion,
                    kind: resource.kind,
                    metadata: {
                        name: args.command,
                        namespace: options_1.getNamespace(args) || 'default'
                    },
                    isSimulacrum: true,
                    originatingCommand: args.command,
                    modes: [],
                    data
                };
            }
            return Object.assign(resource, {
                prettyName,
                nameHash,
                originatingCommand: args.command,
                modes: [],
                data
            });
        }
        catch (err) {
            console.error('error handling entity response; raw=', response.content.stdout);
            throw err;
        }
    });
}
exports.doGetAsEntity = doGetAsEntity;
function doGetCustom(args, response) {
    return __awaiter(this, void 0, void 0, function* () {
        return response.content.stdout.trim();
    });
}
function rawGet(args, _command = 'kubectl') {
    const command = _command === 'k' ? 'kubectl' : _command;
    return exec_1.exec(args, prepareArgsForGet, command).catch((err) => {
        delete err.statusCode;
        err.message = err.message.trim();
        throw err;
    });
}
exports.rawGet = rawGet;
exports.doGet = (command) => function doGet(args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!core_1.isHeadless() && options_1.isWatchRequest(args)) {
            if (!/^k(ubectl)?\s+-/.test(args.command)) {
                return get_watch_1.default(args);
            }
        }
        const response = yield rawGet(args, command);
        if (formatTable_1.isKubeTableResponse(response)) {
            return response;
        }
        else if (response.content.code !== 0) {
            const err = new Error(response.content.stderr);
            err.code = response.content.code;
            throw err;
        }
        else if (response.content.wasSentToPty) {
            return response.content.stdout;
        }
        else if (options_1.isEntityRequest(args)) {
            return doGetAsEntity(args, response);
        }
        else if (options_1.isTableRequest(args)) {
            return doGetAsTable(command, args, response);
        }
        else {
            return doGetCustom(args, response);
        }
    });
};
exports.default = (commandTree) => {
    commandTree.listen(`/${command_prefix_1.default}/kubectl/get`, exports.doGet('kubectl'), flags_1.default);
    commandTree.listen(`/${command_prefix_1.default}/k/get`, exports.doGet('kubectl'), flags_1.default);
};
//# sourceMappingURL=get.js.map