"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const child_process_1 = require("child_process");
const core_1 = require("@kui-shell/core");
const flags_1 = require("./flags");
const command_prefix_1 = require("../command-prefix");
const debug = debug_1.default('plugin-kubeui/controller/kubectl/raw');
exports.doNativeExec = (args) => new Promise((resolve, reject) => {
    const env = Object.assign({}, !core_1.inBrowser() ? process.env : {}, args.execOptions.env);
    delete env.DEBUG;
    if (args.parsedOptions.f || args.parsedOptions.filename) {
        const filename = core_1.expandHomeDir(args.parsedOptions.f || args.parsedOptions.filename);
        const idx = args.argv.indexOf(args.parsedOptions.f ? '-f' : '--filename');
        if (idx >= 0) {
            args.argv[idx + 1] = filename;
        }
    }
    const executable = args.argv[0].replace(/^_/, '');
    const child = child_process_1.spawn(executable, args.argv.slice(1), { env });
    child.on('error', (err) => {
        console.error(`error spawning ${executable}`, err);
        reject(err);
    });
    let stdout = '';
    child.stdout.on('data', data => {
        stdout += data.toString();
    });
    let stderr = '';
    child.stderr.on('data', data => {
        stderr += data.toString();
    });
    child.on('close', (code) => __awaiter(void 0, void 0, void 0, function* () {
        if (stderr.length > 0 || code !== 0) {
            debug('exec has stderr with code %s', code);
            debug('exec stderr command', args.command);
            debug('exec stderr', stderr);
        }
        const noResources = stderr.match(/no resources found/i);
        if (code !== 0 || noResources) {
            const message = stderr;
            const fileNotFound = message.match(/error: the path/);
            const codeForREPL = noResources || message.match(/not found/i) || message.match(/doesn't have/i)
                ? 404
                : message.match(/already exists/i)
                    ? 409
                    : fileNotFound
                        ? 412
                        : 500;
            if (args.execOptions.failWithUsage) {
                reject(new Error(undefined));
            }
            else {
                const error = new Error(message);
                error.statusCode = code;
                error.code = codeForREPL;
                reject(error);
            }
        }
        else {
            resolve({
                content: {
                    code,
                    stdout,
                    stderr,
                    wasSentToPty: false
                }
            });
        }
    }));
});
function doExecRaw(command, parsedOptions, execOptions) {
    return __awaiter(this, void 0, void 0, function* () {
        return (yield exports.doNativeExec({ command, argv: core_1.split(command), parsedOptions, execOptions })).content.stdout;
    });
}
exports.doExecRaw = doExecRaw;
exports.default = (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    registrar.listen(`/${command_prefix_1.default}/_kubectl`, exports.doNativeExec, Object.assign({}, flags_1.default, { requiresLocal: true, inBrowserOk: false }));
});
//# sourceMappingURL=raw.js.map