"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const localStorageKey = {
    auth: 'kui.k8s.auth'
};
exports.setAuth = (kubeconfigString, ca, cafile) => {
    const auth = {
        kubeconfig: kubeconfigString,
        ca: ca,
        cafile
    };
    core_1.setHasAuth('k8s', auth);
    core_1.Store().setItem(localStorageKey.auth, JSON.stringify(auth));
};
exports.restoreAuth = () => {
    const maybe = core_1.Store().getItem(localStorageKey.auth);
    if (maybe) {
        try {
            core_1.setHasAuth('k8s', JSON.parse(maybe));
        }
        catch (err) {
            console.error('error parsing k8s auth from localStorage', err);
        }
    }
};
//# sourceMappingURL=auth.js.map