import { ResourceWithMetadata } from '@kui-shell/core';
import kubeuiApiVersion from '../../controller/kubectl/apiVersion';
export interface KubeStatusCondition {
    lastProbeTime?: string;
    lastUpdateTime: string;
    lastTransitionTime: string;
    status: string | boolean;
    reason?: string;
    message: string;
    type?: string;
    phase?: string;
}
interface KubeContainerStatus {
    name: string;
    containerID: string;
    restartCount: number;
    ready: boolean;
    state: any;
}
export interface KubeLoadBalancer {
    ingress: string;
}
export interface KubeStatus {
    message?: string;
    state?: string;
    startTime?: string;
    completionTime?: string;
    phase?: string;
    podIP?: string;
    podName?: string;
    qosClass?: string;
    replicas?: number;
    readyReplicas?: number;
    availableReplicas?: number;
    unavailableReplicas?: number;
    updatedReplicas?: number;
    loadBalancer?: KubeLoadBalancer;
    containerStatuses?: KubeContainerStatus[];
    conditions?: KubeStatusCondition[];
}
export declare class DefaultKubeStatus implements KubeStatus {
    message: any;
}
interface OwnerReferences {
    kind: string;
    name: string;
}
export interface KubeMetadata {
    name: string;
    namespace?: string;
    labels?: {
        [key: string]: string;
    };
    annotations?: object;
    creationTimestamp?: string;
    generation?: string;
    ownerReferences?: OwnerReferences[];
}
export declare class DefaultKubeMetadata implements KubeMetadata {
    kind: any;
    name: any;
}
interface RoleRule {
    apiGroups: string[];
    resources: string[];
    verbs: string[];
}
interface RoleRef {
    apiGroup: string;
    kind: string;
    name: string;
}
export interface WithRawData<Content = void> extends ResourceWithMetadata<Content> {
    data?: string;
}
export declare function hasRawData(resource: ResourceWithMetadata): boolean;
export declare type KubeResource<Status = KubeStatus> = ResourceWithMetadata & WithRawData & {
    apiVersion: string;
    kind: string;
    metadata?: KubeMetadata;
    status?: Status;
    spec?: any;
    originatingCommand: string;
    isSimulacrum?: boolean;
};
export declare function isNamespaced(resource: KubeResource): boolean;
export declare function isKubeResource(entity: ResourceWithMetadata): entity is KubeResource;
export declare function isCrudableKubeResource(entity: ResourceWithMetadata): entity is KubeResource;
export interface WithSummary {
    summary: {
        content: string;
        contentType?: 'yaml' | 'text/markdown';
    };
}
export declare type KubeResourceWithSummary<Status = KubeStatus> = KubeResource<Status> & WithSummary;
export declare function isKubeResourceWithItsOwnSummary(resource: KubeResource): resource is KubeResourceWithSummary;
export declare function isSummarizableKubeResource(resource: KubeResource): boolean;
interface Role extends KubeResource {
    rules: RoleRule[];
}
export declare function isRole(resource: KubeResource): resource is Role;
interface RoleBinding extends KubeResource {
    roleRef: RoleRef;
    subjects: {
        kind: string;
        name: string;
    }[];
}
export declare function isRoleBinding(resource: KubeResource): resource is RoleBinding;
interface ServiceAccount extends KubeResource {
    secrets: {
        name: string;
    }[];
}
export declare function isServiceAccount(resource: KubeResource): resource is ServiceAccount;
export interface CRDResource extends KubeResource {
    spec: {
        names: {
            kind: string;
            shortnames: string[];
        };
    };
}
export interface Pod extends KubeResource {
    apiVersion: 'v1';
    kind: 'Pod';
    spec: {
        nodeName: string;
        containers: {
            args: string[];
            command: string[];
            env: {
                name: string;
                value: string;
            }[];
            image: string;
            imagePullPolicy: string;
            name: string;
            resource: Record<string, any>;
            terminationMessagePath: string;
            terminationMessagePolicy: string;
            volumneMounts: {
                mountPath: string;
                name: string;
            }[];
            workingDir: string;
        }[];
    };
}
export declare function isPod(resource: KubeResource): resource is Pod;
export interface Namespace extends KubeResource {
    apiVersion: 'v1';
    kind: 'Namespace';
}
export declare function isNamespace(resource: KubeResource): resource is Namespace;
export interface Job extends KubeResource {
    apiVersion: 'batch/v1';
    kind: 'Job';
}
export declare function isJob(resource: KubeResource): resource is Job;
export interface Deployment extends KubeResource {
    apiVersion: 'extensions/v1beta1';
    kind: 'Deployment';
}
export declare function isDeployment(resource: KubeResource): resource is Deployment;
export interface InvolvedObject {
    involvedObject: {
        apiVersion: string;
        kind: string;
        name: string;
        namespace: string;
        uid?: string;
        fieldPath?: string;
        resourceVersion?: string;
    };
}
export declare type KubeResourceWithInvolvedObject = KubeResource & InvolvedObject;
export declare function hasInvolvedObject(resource: KubeResource | KubeResourceWithInvolvedObject): resource is KubeResourceWithInvolvedObject;
export declare type Event = KubeResourceWithInvolvedObject & {
    apiVersion: 'v1';
    kind: 'Event';
    firstTimestamp: string;
    lastTimestamp: string;
    count: number;
    reason: string;
    type: 'Normal' | 'Warning' | 'Error';
};
export declare function isEvent(resource: KubeResource): resource is Event;
export interface KubeItems<Item extends KubeResource = KubeResource> extends KubeResource {
    apiVersion: 'v1';
    kind: 'List';
    items: Item[];
}
export declare function isKubeItems(resource: KubeResource): resource is KubeItems;
declare type Scope = 'Namespaced' | 'Cluster';
export declare type CustomResourceDefinition = KubeResource & {
    apiVersion: 'apiextensions.k8s.io/v1' | 'apiextensions.k8s.io/v1beta1';
    kind: 'CustomResourceDefinition';
    spec: {
        scope: Scope;
        group: string;
        version: string;
        names: {
            categories: Record<string, string>;
            kind: string;
            listKind: string;
            plural: string;
            singular: string;
        };
    };
};
export declare function isCustomResourceDefinition(resource: KubeResource): resource is CustomResourceDefinition;
export interface KubeContext extends KubeResource {
    apiVersion: typeof kubeuiApiVersion;
    kind: 'Context';
    spec: {
        user: string;
        cluster: string;
    };
}
export interface Resource<T = KubeResource> {
    filepathForDrilldown?: string;
    kind?: string;
    name?: string;
    resource: T;
}
export default KubeResource;
