"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apiVersion_1 = require("../../controller/kubectl/apiVersion");
class DefaultKubeStatus {
    constructor() {
        this.message = undefined;
    }
}
exports.DefaultKubeStatus = DefaultKubeStatus;
class DefaultKubeMetadata {
    constructor() {
        this.kind = undefined;
        this.name = undefined;
    }
}
exports.DefaultKubeMetadata = DefaultKubeMetadata;
function hasRawData(resource) {
    const withData = resource;
    return typeof withData.data === 'string';
}
exports.hasRawData = hasRawData;
function isNamespaced(resource) {
    return resource.metadata !== undefined && resource.metadata.namespace !== undefined;
}
exports.isNamespaced = isNamespaced;
function isKubeResource(entity) {
    const kube = entity;
    return kube.apiVersion !== undefined && kube.apiVersion !== apiVersion_1.default && kube.kind !== undefined;
}
exports.isKubeResource = isKubeResource;
function isCrudableKubeResource(entity) {
    return isKubeResource(entity) && !entity.isSimulacrum;
}
exports.isCrudableKubeResource = isCrudableKubeResource;
function isKubeResourceWithItsOwnSummary(resource) {
    return resource !== undefined && resource.summary !== undefined;
}
exports.isKubeResourceWithItsOwnSummary = isKubeResourceWithItsOwnSummary;
function isSummarizableKubeResource(resource) {
    return (isKubeResource(resource) &&
        (isKubeResourceWithItsOwnSummary(resource) ||
            (resource.kind !== undefined && resource.kind !== 'List' && resource.kind !== 'CustomResourceDefinition')));
}
exports.isSummarizableKubeResource = isSummarizableKubeResource;
function isRole(resource) {
    const role = resource;
    return role.rules !== undefined;
}
exports.isRole = isRole;
function isRoleBinding(resource) {
    const rb = resource;
    return rb.roleRef !== undefined && rb.subjects !== undefined;
}
exports.isRoleBinding = isRoleBinding;
function isServiceAccount(resource) {
    const sa = resource;
    return sa.secrets !== undefined;
}
exports.isServiceAccount = isServiceAccount;
function isPod(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Pod';
}
exports.isPod = isPod;
function isNamespace(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Namespace';
}
exports.isNamespace = isNamespace;
function isJob(resource) {
    return resource.apiVersion === 'batch/v1' && resource.kind === 'Job';
}
exports.isJob = isJob;
function isDeployment(resource) {
    return resource.apiVersion === 'extensions/v1beta1' && resource.kind === 'Deployment';
}
exports.isDeployment = isDeployment;
function hasInvolvedObject(resource) {
    const io = resource;
    return (io.involvedObject !== undefined &&
        typeof io.involvedObject.apiVersion === 'string' &&
        typeof io.involvedObject.kind === 'string' &&
        typeof io.involvedObject.name === 'string');
}
exports.hasInvolvedObject = hasInvolvedObject;
function isEvent(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Event';
}
exports.isEvent = isEvent;
function isKubeItems(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'List';
}
exports.isKubeItems = isKubeItems;
function isCustomResourceDefinition(resource) {
    return ((resource.apiVersion === 'apiextensions.k8s.io/v1' || resource.apiVersion === 'apiextensions.k8s.io/v1beta1') &&
        resource.kind === 'CustomResourceDefinition');
}
exports.isCustomResourceDefinition = isCustomResourceDefinition;
//# sourceMappingURL=resource.js.map