"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const removeSolitaryAndTrailingPeriod = (str) => str.replace(/^\s*([^.]+)[.]\s*$/, '$1').trim();
exports.renderHelp = (out, command, verb, exitCode) => {
    const splitOutUse = out.match(/((Use[^\n]+\n)+)$/);
    const nonUseOut = !splitOutUse ? out : out.substring(0, splitOutUse.index);
    const usePart = splitOutUse && splitOutUse[1].split(/\n/);
    const rawSections = nonUseOut.split(/\n([^'\s].*:)\n/);
    const header = rawSections[0];
    const detailedExampleFromUsePart = usePart &&
        usePart
            .filter(x => x)
            .map(line => {
            const [, command, docs] = line.split(/^Use "([^"]+)"\s+(.*)\s*$/);
            return { command, docs };
        });
    const _allSections = rawSections.slice(1).reduce((S, _, idx, sections) => {
        if (idx % 2 === 0) {
            S.push({
                title: sections[idx],
                content: sections[idx + 1].replace(/^\n/, '')
            });
        }
        return S;
    }, []);
    const allSections = [_allSections[0]].concat(_allSections.slice(1).sort((a, b) => -a.title.localeCompare(b.title)));
    const intro = undefined;
    const usageSection = allSections.filter(({ title }) => title === 'Usage:');
    const examplesSection = allSections.find(({ title }) => title === 'Examples:');
    const remainingSections = allSections
        .filter(({ title }) => title !== 'Usage:' && title !== 'Examples:');
    const sections = remainingSections.map(({ title, content }) => {
        return {
            title,
            nRowsInViewport: title.match(/Available Commands/i) ? 8 : undefined,
            rows: content
                .split(/[\n\r]/)
                .filter(x => x)
                .map(line => line.split(/(\t|(\s\s)+\s?)|(?=:\s)/).filter(x => x && !/(\t|\s\s)/.test(x)))
                .map(([thisCommand, docs]) => {
                if (thisCommand) {
                    return {
                        command: thisCommand.replace(/^\s*-\s+/, '').replace(/:\s*$/, ''),
                        docs: docs && docs.replace(/^\s*:\s*/, ''),
                        commandPrefix: /Commands/i.test(title) && `${command} ${verb || ''}`,
                        noclick: !title.match(/Common actions/i) && !title.match(/Commands/i)
                    };
                }
            })
                .filter(x => x)
        };
    });
    const detailedExample = (detailedExampleFromUsePart || []).concat((examplesSection ? examplesSection.content : '')
        .split(/^\s*(?:#\s+)/gm)
        .map(x => x.trim())
        .filter(x => x)
        .map(group => {
        const match = group.match(/(.*)[\n\r]([\s\S]+)/);
        if (match && match.length === 3) {
            const [, firstPartFull, secondPartFull] = match;
            const firstPart = removeSolitaryAndTrailingPeriod(firstPartFull);
            const secondPart = removeSolitaryAndTrailingPeriod(secondPartFull);
            const secondPartIsMultiLine = secondPart.split(/[\n\r]/).length > 1;
            const command = secondPartIsMultiLine ? firstPart : secondPart;
            const docs = secondPartIsMultiLine ? secondPart : firstPart;
            return {
                command,
                docs
            };
        }
        else {
            return {
                copyToNextLine: group
            };
        }
    })
        .reduce((lines, lineRecord, idx, A) => {
        for (let jdx = idx - 1; jdx >= 0; jdx--) {
            if (A[jdx].copyToNextLine) {
                lineRecord.docs = `${A[jdx].copyToNextLine}\n${lineRecord.docs}`;
            }
            else {
                break;
            }
        }
        if (!lineRecord.copyToNextLine) {
            lines.push(lineRecord);
        }
        return lines;
    }, [])
        .filter(x => x));
    return new core_1.UsageError({
        exitCode,
        usage: {
            commandPrefix: command,
            commandSuffix: '-h',
            breadcrumb: verb || command,
            parents: verb ? [command] : [],
            header,
            intro,
            sections,
            detailedExample,
            example: usageSection && usageSection[0] && usageSection[0].content.replace(/\s+$/, '')
        }
    });
};
//# sourceMappingURL=help.js.map