"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const command_prefix_1 = require("../../controller/command-prefix");
exports.maybeAsDate = str => {
    try {
        const localized = new Date(str).toLocaleString();
        if (localized === 'Invalid Date') {
            return str;
        }
        else {
            return localized;
        }
    }
    catch (err) {
        return str;
    }
};
exports.isDirectory = (filepath) => new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
    const { inBrowser } = yield Promise.resolve().then(() => require('@kui-shell/core'));
    if (inBrowser()) {
        resolve(false);
    }
    else {
        const { lstat } = yield Promise.resolve().then(() => require('fs'));
        lstat(filepath, (err, stats) => {
            if (err) {
                if (err.code === 'ENOENT') {
                    resolve(undefined);
                }
                else {
                    reject(err);
                }
            }
            else {
                resolve(stats.isDirectory());
            }
        });
    }
}));
exports.toOpenWhiskFQN = ({ kind, spec, metadata }) => {
    if (kind === 'Function' || kind === 'Composition') {
        const actionName = spec.name || metadata.name;
        const packageName = spec.package;
        return {
            type: kind === 'Function' ? 'action' : 'app',
            packageName,
            actionName,
            fqn: packageName ? `${packageName}/${actionName}` : actionName
        };
    }
    else if (kind === 'Composition') {
        return { type: 'app', fqn: metadata.name };
    }
    else if (kind === 'Package' || kind === 'Rule' || kind === 'Trigger') {
        return { type: kind.toLowerCase(), fqn: metadata.name };
    }
    else {
        return { type: 'unknown', fqn: metadata.name };
    }
};
class StatusError extends Error {
}
exports.StatusError = StatusError;
class TryLaterError extends StatusError {
}
exports.TryLaterError = TryLaterError;
class NotFoundError extends StatusError {
    constructor(message, code = 404) {
        super(message);
        this.code = code;
    }
}
exports.NotFoundError = NotFoundError;
exports.getCommandFromArgs = (args) => {
    return args.argvNoOptions[0] === command_prefix_1.default ? args.argvNoOptions[1] : args.argvNoOptions[0];
};
exports.commandWithoutResource = (args) => {
    if (args.argvNoOptions[0] === command_prefix_1.default) {
        return args.argvNoOptions.length === 3;
    }
    else {
        return args.argvNoOptions.length === 2;
    }
};
//# sourceMappingURL=util.js.map