"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fqn_1 = require("../../../controller/kubectl/fqn");
const util_1 = require("../../../lib/util/util");
exports.renderButton = (mode) => (tab, resource, args) => `${util_1.getCommandFromArgs(args)} ${mode} ${fqn_1.fqnOf(resource)}`;
const makeButton = (overrides) => ({
    mode: overrides.mode,
    label: overrides.label,
    kind: 'drilldown',
    command: exports.renderButton(overrides.mode),
    confirm: true
});
exports.default = makeButton;
//# sourceMappingURL=button.js.map