"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const resource_1 = require("../../model/resource");
const show_crd_managed_resources_1 = require("./show-crd-managed-resources");
const strings = core_1.i18n('plugin-kubeui');
const debug = debug_1.default('plugin-kubeui/view/modes/crd-summary');
function content(tab, crd, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const { group, version, scope } = crd.spec;
        const kind = crd.spec.names.kind;
        const scopeObj = scope ? { scope } : {};
        const groupObj = group ? { group } : {};
        const versionObj = version ? { version } : {};
        const kindObj = kind ? { kind } : {};
        const baseResponse = Object.assign({}, scopeObj, groupObj, versionObj, kindObj);
        try {
            const [{ safeDump }, { body: resources }] = yield Promise.all([
                Promise.resolve().then(() => require('js-yaml')),
                tab.REPL.qexec(`${show_crd_managed_resources_1.command(tab, crd, args)} -o custom-columns=NAME:.metadata.name`)
            ]);
            const countObj = { 'resource count': resources.length };
            return {
                content: safeDump(Object.assign(baseResponse, countObj)),
                contentType: 'yaml'
            };
        }
        catch (err) {
            debug('error trying to determine resource count for crd', err);
            const safeDump = yield Promise.resolve().then(() => require('js-yaml'));
            return {
                content: safeDump(baseResponse),
                contentType: 'yaml'
            };
        }
    });
}
const mode = {
    when: resource_1.isCustomResourceDefinition,
    mode: {
        mode: 'summary',
        label: strings('summary'),
        content,
        priority: 10
    }
};
exports.default = mode;
//# sourceMappingURL=crd-summary.js.map