"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const resource_1 = require("../../model/resource");
const fqn_1 = require("../../../controller/kubectl/fqn");
const util_1 = require("../../../lib/util/util");
const strings = core_1.i18n('plugin-kubeui');
function command(tab, crd, args) {
    return `${util_1.getCommandFromArgs(args)} get ${fqn_1.fqn(crd.apiVersion, core_1.encodeComponent(crd.kind), core_1.encodeComponent(crd.metadata.name), core_1.encodeComponent(crd.metadata.namespace || 'default'))}`;
}
exports.command = command;
const mode = {
    when: resource_1.isCustomResourceDefinition,
    mode: {
        mode: 'show-crd-resources',
        label: strings('Show Resources'),
        command,
        kind: 'drilldown'
    }
};
exports.default = mode;
//# sourceMappingURL=show-crd-managed-resources.js.map