"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const contexts_1 = require("../../../controller/kubectl/contexts");
const icon = '<svg focusable="false" preserveAspectRatio="xMidYMid meet" style="will-change: transform;" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 32 32" aria-hidden="true"><path d="M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"></path><title>At</title></svg>';
function renderContext(context) {
    return context.metadata.namespace;
}
function listener(tab, controller, fragment) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const currentContext = yield contexts_1.getCurrentContext(tab);
            core_1.eventBus.emit('/kubeui/context/current', currentContext);
            fragment.text.innerText = currentContext === undefined ? '' : renderContext(currentContext);
            controller.showAs('normal');
        }
        catch (err) {
            controller.showAs('hidden');
        }
    });
}
function default_1() {
    const fragment = {
        id: 'kui--plugin-kubeui--current-namespace',
        icon,
        iconIsNarrow: true,
        text: document.createElement('div'),
        onclick: {
            text: 'kubectl get namespaces'
        }
    };
    return {
        fragment,
        listener
    };
}
exports.default = default_1;
//# sourceMappingURL=current-namespace.js.map