var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n, Table } from '@kui-shell/core';
import flags from './flags';
import apiVersion from './apiVersion';
import commandPrefix from '../command-prefix';
import { doExecWithTable } from './exec';
const strings = i18n('plugin-kubeui');
const usage = {
    context: (command) => ({
        command,
        strict: command,
        docs: 'Print your current kubernetes context',
        example: 'kubectl context'
    }),
    contexts: (command) => ({
        command,
        strict: command,
        docs: 'List your available kubernetes contexts',
        example: 'kubectl contexts'
    })
};
const addClickHandlers = (table, { REPL }, execOptions) => {
    const body = table.body.map(row => {
        const nameAttr = row.attributes.find(({ key }) => key === 'NAME');
        const { value: contextName } = nameAttr;
        nameAttr.outerCSS += ' entity-name-group-narrow';
        const onclick = () => __awaiter(void 0, void 0, void 0, function* () {
            yield REPL.qexec(`kubectl config use-context ${REPL.encodeComponent(contextName)}`, undefined, undefined, Object.assign({}, execOptions, { raw: true }));
            row.setSelected();
        });
        row.name = contextName;
        row.onclick = onclick;
        nameAttr.onclick = onclick;
        return row;
    });
    return new Table({
        header: table.header,
        body: body,
        title: strings('contextsTableTitle')
    });
};
function valueOf(key, row) {
    const cell = row.attributes.find(_ => _.key === key);
    return cell ? cell.value : '';
}
export function getCurrentContext(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        const [currentContextName, { content: contexts }] = yield Promise.all([
            tab.REPL.qexec(`context`),
            tab.REPL.rexec(`contexts`)
        ]);
        return contexts.find(_ => _.metadata.name === currentContextName);
    });
}
const listContexts = (args) => __awaiter(void 0, void 0, void 0, function* () {
    const execOptions = Object.assign({}, args.execOptions, { render: false });
    const contexts = yield args.REPL.qexec(`kubectl config get-contexts`, undefined, undefined, execOptions);
    if (args.execOptions.raw) {
        return {
            mode: 'raw',
            content: contexts.body.map(_ => ({
                apiVersion,
                kind: 'Context',
                originatingCommand: args.command,
                metadata: {
                    name: valueOf('NAME', _),
                    namespace: valueOf('NAMESPACE', _)
                },
                spec: {
                    user: valueOf('AUTHINFO', _),
                    cluster: valueOf('CLUSTER', _)
                }
            }))
        };
    }
    else {
        return addClickHandlers(contexts, args, execOptions);
    }
});
export default (commandTree) => {
    commandTree.listen(`/${commandPrefix}/kubectl/config/get-contexts`, doExecWithTable, flags);
    commandTree.listen(`/${commandPrefix}/context`, ({ REPL }) => __awaiter(void 0, void 0, void 0, function* () {
        return (yield REPL.qexec('kubectl config current-context')).trim();
    }), Object.assign({
        usage: usage.context('context')
    }, flags));
    commandTree.listen(`/${commandPrefix}/contexts`, listContexts, Object.assign({
        usage: usage.contexts('contexts')
    }, flags));
};
//# sourceMappingURL=contexts.js.map