import { Table, Arguments, MixedResponse, KResponse } from '@kui-shell/core';
import RawResponse from './response';
import { KubeOptions } from './options';
import { FinalState } from '../../lib/model/states';
import { KubeTableResponse } from '../../lib/view/formatTable';
export declare type Prepare<O extends KubeOptions> = (args: Arguments<O>) => string;
export declare type PrepareForStatus<O extends KubeOptions> = (cmd: string, args: Arguments<O>) => string;
export declare function doExecWithStdout<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, exec?: string): Promise<string>;
export declare const isUsage: (args: Arguments<KubeOptions>) => boolean;
export declare function doExecWithPty<Content = void, Response extends KResponse<Content> = KResponse<Content>, O extends KubeOptions = KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>): Promise<string | Response>;
export declare function exec<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>, exec?: string): Promise<RawResponse>;
export declare function doExecWithTable<O extends KubeOptions>(args: Arguments<O>, prepare?: Prepare<O>): Promise<Table | MixedResponse>;
export declare const doExecWithStatus: <O extends KubeOptions>(cmd: string, finalState: FinalState, command?: string, prepareForExec?: Prepare<O>, prepareForStatus?: PrepareForStatus<O>) => (args: Arguments<O>) => Promise<KubeTableResponse>;
export default exec;
