var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { ExecType, isHeadless } from '@kui-shell/core';
import flags from './flags';
import { exec } from './exec';
import doGetWatchTable from './watch/get-watch';
import commandPrefix from '../command-prefix';
import extractAppAndName from '../../lib/util/name';
import { isEntityRequest, isTableRequest, formatOf, isWatchRequest, getNamespace } from './options';
import { stringToTable, isKubeTableResponse } from '../../lib/view/formatTable';
function prepareArgsForGet(args) {
    const stripThese = ['-w=true', '--watch=true', '--watch-only=true', '-w', '--watch', '--watch-only'];
    const idx = args.command.indexOf(' get ') + ' get '.length;
    const pre = args.command.slice(0, idx - 1);
    const post = args.command.slice(idx - 1);
    return pre + stripThese.reduce((cmd, strip) => cmd.replace(new RegExp(`(\\s)${strip}`), '$1'), post);
}
export function doGetAsTable(command, args, response, verb = 'get') {
    const { content: { stderr, stdout } } = response;
    const entityType = args.argvNoOptions[args.argvNoOptions.indexOf(verb) + 1];
    return stringToTable(stdout, stderr, args, command, verb, entityType);
}
export function doGetAsEntity(args, response) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const data = response.content.stdout;
            const resource = formatOf(args) === 'json' ? JSON.parse(data) : (yield import('js-yaml')).safeLoad(data);
            const { name: prettyName, nameHash } = extractAppAndName(resource);
            if (resource.kind === 'List' && args.execOptions.type === ExecType.TopLevel) {
                return {
                    apiVersion: resource.apiVersion,
                    kind: resource.kind,
                    metadata: {
                        name: args.command,
                        namespace: getNamespace(args) || 'default'
                    },
                    isSimulacrum: true,
                    originatingCommand: args.command,
                    modes: [],
                    data
                };
            }
            return Object.assign(resource, {
                prettyName,
                nameHash,
                originatingCommand: args.command,
                modes: [],
                data
            });
        }
        catch (err) {
            console.error('error handling entity response; raw=', response.content.stdout);
            throw err;
        }
    });
}
function doGetCustom(args, response) {
    return __awaiter(this, void 0, void 0, function* () {
        return response.content.stdout.trim();
    });
}
export function rawGet(args, _command = 'kubectl') {
    const command = _command === 'k' ? 'kubectl' : _command;
    return exec(args, prepareArgsForGet, command).catch((err) => {
        delete err.statusCode;
        err.message = err.message.trim();
        throw err;
    });
}
export const doGet = (command) => function doGet(args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!isHeadless() && isWatchRequest(args)) {
            if (!/^k(ubectl)?\s+-/.test(args.command)) {
                return doGetWatchTable(args);
            }
        }
        const response = yield rawGet(args, command);
        if (isKubeTableResponse(response)) {
            return response;
        }
        else if (response.content.code !== 0) {
            const err = new Error(response.content.stderr);
            err.code = response.content.code;
            throw err;
        }
        else if (response.content.wasSentToPty) {
            return response.content.stdout;
        }
        else if (isEntityRequest(args)) {
            return doGetAsEntity(args, response);
        }
        else if (isTableRequest(args)) {
            return doGetAsTable(command, args, response);
        }
        else {
            return doGetCustom(args, response);
        }
    });
};
export default (commandTree) => {
    commandTree.listen(`/${commandPrefix}/kubectl/get`, doGet('kubectl'), flags);
    commandTree.listen(`/${commandPrefix}/k/get`, doGet('kubectl'), flags);
};
//# sourceMappingURL=get.js.map