var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import fqn from '../fqn';
import { formatOf } from '../options';
import { preprocessTable } from '../../../lib/view/formatTable';
import { getCommandFromArgs } from '../../../lib/util/util';
const debug = Debug('plugin-kubeui/controller/watch/watcher');
function isFullRow(row, nCols) {
    return row.length === nCols && row.every(_ => _.value.length > 0);
}
function findFullRows(arr, nCols) {
    if (arr.length > 0) {
        const startIdx = arr.findIndex(row => row.length === nCols && row[0].value !== 'NAME');
        if (startIdx >= 0) {
            for (let idx = startIdx; idx < arr.length; idx++) {
                if (isFullRow(arr[idx], nCols)) {
                    for (let jdx = arr.length - 1; jdx >= idx; jdx--) {
                        if (isFullRow(arr[jdx], nCols)) {
                            return { firstFullIdx: idx, lastFullIdx: jdx };
                        }
                    }
                    return { firstFullIdx: idx, lastFullIdx: idx };
                }
            }
        }
    }
    return { firstFullIdx: -1, lastFullIdx: -1 };
}
class KubectlWatcher {
    constructor(args, output = formatOf(args)) {
        this.args = args;
        this.output = output;
        this.nCols = 4;
    }
    abort() {
        if (this.ptyJob) {
            this.ptyJob.abort();
            this.ptyJob = undefined;
        }
    }
    onPTYInit(ptyJob) {
        debug('onPTYInit');
        this.ptyJob = ptyJob;
        return (_) => __awaiter(this, void 0, void 0, function* () {
            if (typeof _ === 'string') {
                debug('streaming pty output', _);
                if (/not found/.test(_)) {
                    this.pusher.allOffline();
                    return;
                }
                const rawData = this.leftover ? this.leftover + _ : _;
                this.leftover = undefined;
                const allRows = preprocessTable([rawData])[0];
                const { firstFullIdx, lastFullIdx } = findFullRows(allRows, this.nCols);
                if (lastFullIdx < 0) {
                    debug('no full rows', _);
                    this.leftover = _;
                    return;
                }
                else if (lastFullIdx < allRows.length - 1) {
                    const lastNewlineIdx = _.lastIndexOf('\n');
                    this.leftover = _.slice(lastNewlineIdx);
                }
                const rows = allRows.slice(firstFullIdx, lastFullIdx + 1);
                const tables = yield Promise.all(rows.map((row) => __awaiter(this, void 0, void 0, function* () {
                    try {
                        const [{ value: name }, { value: kind }, { value: apiVersion }, { value: namespace }] = row;
                        const getCommand = `${getCommandFromArgs(this.args)} get ${fqn(apiVersion, kind, name, namespace)} ${this.output ? `-o ${this.output}` : ''}`;
                        return this.args.REPL.qexec(getCommand).catch((err) => {
                            if (err.code !== 404) {
                                console.error(err);
                            }
                            this.pusher.offline(name);
                        });
                    }
                    catch (err) {
                        console.error('error handling watched row', err);
                    }
                })));
                const tableWithHeader = tables.find(table => table && table.header);
                if (tableWithHeader && tableWithHeader.header) {
                    this.pusher.header(tableWithHeader.header);
                }
                tables.forEach(table => {
                    if (table) {
                        table.body.forEach(row => {
                            this.pusher.update(row);
                        });
                    }
                });
            }
            else {
                console.error('unknown streamable type', _);
            }
        });
    }
    init(pusher) {
        return __awaiter(this, void 0, void 0, function* () {
            this.pusher = pusher;
            const command = this.args.command
                .replace(/^k(\s)/, 'kubectl$1')
                .replace(/--watch=true|-w=true|--watch-only=true|--watch|-w|--watch-only/g, '--watch')
                .replace(new RegExp(`(-o|--output)(\\s+|=)${this.output}`), '') +
                ` -o custom-columns=NAME:.metadata.name,KIND:.kind,APIVERSION:.apiVersion,NAMESPACE:.metadata.namespace`;
            this.args.REPL.qexec(`sendtopty ${command}`, this.args.block, undefined, {
                quiet: true,
                replSilence: true,
                echo: false,
                onInit: this.onPTYInit.bind(this)
            }).catch(err => {
                debug('pty error', err);
            });
        });
    }
}
export default function doGetWatchTable(args) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const cmd = args.command
                .replace(/^k(\s)/, 'kubectl$1')
                .replace(/--watch=true|-w=true|--watch-only=true|--watch|-w|--watch-only/g, '');
            const initialTable = yield args.REPL.qexec(cmd).catch((err) => {
                if (err.code !== 404) {
                    throw err;
                }
                else {
                    const argv = args.argvNoOptions;
                    const idx = argv.indexOf('get') + 1;
                    const kind = argv[idx];
                    const name = argv[idx + 1];
                    if (kind && name) {
                        throw err;
                    }
                    else {
                        return {
                            body: []
                        };
                    }
                }
            });
            if (typeof initialTable === 'string') {
                return args.execOptions.initialResponse || initialTable;
            }
            else {
                return {
                    header: initialTable.header,
                    body: initialTable.body,
                    watch: new KubectlWatcher(args)
                };
            }
        }
        catch (err) {
            const message = args.execOptions.initialResponse || err.message;
            err.message = message;
            throw err;
        }
    });
}
//# sourceMappingURL=get-watch.js.map